/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.dos.DosStatisticsException;
import com.huawei.springframework.security.web.dos.DosStatisticsRepository;
import com.huawei.springframework.security.web.dos.TokenBucket;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessoionDosStatisticsRepository
implements DosStatisticsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessoionDosStatisticsRepository.class);
    private static final String DOS_STATISTICS_SESSION_KEY = "DOS_STATISTICS_SESSION_KEY";
    private final Object lock = new Object();

    public static <T> TokenBucket getTokenBucket(T bucket) {
        TokenBucket tokenbucket = null;
        if (bucket instanceof TokenBucket) {
            tokenbucket = (TokenBucket)bucket;
        }
        return tokenbucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenBucket getStatistics(HttpServletRequest request, DosConfig config) throws DosStatisticsException {
        HttpSession session = request.getSession(true);
        TokenBucket bucket = HttpSessoionDosStatisticsRepository.getTokenBucket(session.getAttribute(DOS_STATISTICS_SESSION_KEY));
        if (bucket == null) {
            Object object = this.lock;
            synchronized (object) {
                bucket = HttpSessoionDosStatisticsRepository.getTokenBucket(session.getAttribute(DOS_STATISTICS_SESSION_KEY));
                if (bucket == null) {
                    bucket = new TokenBucket(config);
                    session.setAttribute(DOS_STATISTICS_SESSION_KEY, (Object)bucket);
                }
            }
        }
        return bucket;
    }

    @Override
    public void removeStatistics(HttpServletRequest request, TokenBucket bucket) throws DosStatisticsException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            if (session.getAttribute(DOS_STATISTICS_SESSION_KEY) == null) {
                LOG.error("[WSF-Core] Fail to remove TokenBucket, because TokenBucket object dose not exist.");
                throw new DosStatisticsException("Fail to remove TokenBucket.");
            }
        } else {
            LOG.error("[WSF-Core] Fail to remove TokenBucket, because session and TokenBucket object do not exist.");
            throw new DosStatisticsException("Fail to remove TokenBucket.");
        }
        session.removeAttribute(DOS_STATISTICS_SESSION_KEY);
    }

    @Override
    public void saveStatistics(HttpServletRequest request, TokenBucket bucket) throws DosStatisticsException {
    }
}

