/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.dos.DosStatisticsException;
import com.huawei.springframework.security.web.dos.DosStatisticsRepository;
import com.huawei.springframework.security.web.dos.TokenBucket;
import com.huawei.springframework.security.web.util.ExpiryDateMap;
import com.huawei.springframework.security.web.util.RequestAddressUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class IPDosStatisticsRepository
implements DosStatisticsRepository {
    private final ConcurrentHashMap<String, TokenBucket> repository;
    private List<String> ipGatewayList;
    private List<String> ipWhiteList;
    private List<String> headerValues;
    private final Object lock = new Object();

    public IPDosStatisticsRepository(List<String> ipGatewayList, List<String> ipWhiteList, List<String> headerValues, Integer clearTime, int maxSize) {
        this.headerValues = headerValues;
        this.ipGatewayList = ipGatewayList;
        this.ipWhiteList = ipWhiteList;
        this.repository = new ExpiryDateMap<String, TokenBucket>((long)clearTime.intValue(), maxSize);
    }

    @Override
    public TokenBucket getStatistics(HttpServletRequest httpServletRequest, DosConfig dosConfig) throws DosStatisticsException {
        TokenBucket tokenBucket;
        try {
            tokenBucket = this.getTokenBucket(httpServletRequest, dosConfig);
        }
        catch (IllegalArgumentException exception) {
            tokenBucket = this.markTokenBucketStatus(dosConfig, exception);
        }
        return tokenBucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenBucket getTokenBucket(HttpServletRequest httpServletRequest, DosConfig dosConfig) {
        String clientIp = RequestAddressUtils.getClientIP(httpServletRequest, this.headerValues, this.ipGatewayList, this.ipWhiteList);
        TokenBucket tokenBucket = this.repository.get(clientIp);
        if (tokenBucket == null) {
            Object object = this.lock;
            synchronized (object) {
                tokenBucket = new TokenBucket(dosConfig);
                this.repository.putIfAbsent(clientIp, tokenBucket);
                tokenBucket = this.repository.get(clientIp);
            }
        }
        return tokenBucket;
    }

    private TokenBucket markTokenBucketStatus(DosConfig dosConfig, IllegalArgumentException exception) {
        TokenBucket tokenBucket = new TokenBucket(dosConfig);
        if ("whiteListIp".equals(exception.getMessage())) {
            tokenBucket.fillWhiteIpList(true);
        }
        if ("illegalIp".equals(exception.getMessage())) {
            tokenBucket.fillIllegalIpList(true);
        }
        return tokenBucket;
    }

    @Override
    public void removeStatistics(HttpServletRequest httpServletRequest, TokenBucket tokenBucket) throws DosStatisticsException {
        try {
            String clientIp = RequestAddressUtils.getClientIP(httpServletRequest, this.headerValues, this.ipGatewayList, this.ipWhiteList);
            TokenBucket bucket = this.repository.get(clientIp);
            if (bucket == null) {
                throw new DosStatisticsException("[WSF-Core] Fail to remove TokenBucket.");
            }
            this.repository.remove(clientIp);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("[WSF-Core] Fail to get ipv4 form request.");
        }
    }

    @Override
    public void saveStatistics(HttpServletRequest httpServletRequest, TokenBucket tokenBucket) throws DosStatisticsException {
    }
}

