/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.access.DefaultAccessDeniedHandlerImpl;
import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.dos.DosStatisticsException;
import com.huawei.springframework.security.web.dos.DosStatisticsProcess;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpringDosPrecautionFilter
extends OncePerRequestFilter {
    private AccessDeniedHandler accessDeniedHandler = null;
    private DosStatisticsProcess process = null;

    public SpringDosPrecautionFilter(DosStatisticsProcess process) {
        this(process, null);
    }

    public SpringDosPrecautionFilter(DosStatisticsProcess process, DosConfig config) {
        this.process = process;
        this.setAccessDeniedHandler(new DefaultAccessDeniedHandlerImpl());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            this.process.doStatistics(request);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (DosStatisticsException e) {
            this.accessDeniedHandler.handle(request, response, new AccessDeniedException(e.getMessage(), (Throwable)e));
        }
    }

    public final void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
    }
}

