/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.util.SerializeLock;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucket
implements Serializable {
    private static final long serialVersionUID = 1567868875894230569L;
    private static final Logger LOG = LoggerFactory.getLogger(TokenBucket.class);
    private final SerializeLock lockObj = new SerializeLock();
    private int count;
    private boolean isWhiteList = false;
    private boolean illegalIp = false;
    private Long lastUpdateTime;
    private int maxTokenNum = 10;
    private int period = 10000;

    public TokenBucket(DosConfig conf) {
        this.setMaxTokenNum(conf.getHits());
        this.setPeriod(conf.getPeriod());
        this.count = this.maxTokenNum;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasToken() {
        SerializeLock serializeLock = this.lockObj;
        synchronized (serializeLock) {
            long interval = System.currentTimeMillis() - this.lastUpdateTime;
            this.lastUpdateTime = System.currentTimeMillis();
            if (interval > 0L) {
                long addTokenNum = interval * (long)this.maxTokenNum / (long)this.period;
                this.count = (long)this.count + addTokenNum > (long)this.maxTokenNum ? this.maxTokenNum : (this.count += (int)addTokenNum);
            }
            if (this.count > 0) {
                --this.count;
                return true;
            }
            return false;
        }
    }

    private void setMaxTokenNum(String hits) {
        try {
            int result = Integer.parseInt(hits);
            if (result > 0) {
                this.maxTokenNum = result;
            } else {
                LOG.info("[WSF-Core] The parameter hits config error, Use the default value: {}.", (Object)this.maxTokenNum);
            }
        }
        catch (NumberFormatException ex) {
            LOG.info("[WSF-Core] The parameter hits config error, Use the default value: {}.", (Object)this.maxTokenNum);
        }
    }

    private void setPeriod(String period) {
        try {
            int result = Integer.parseInt(period);
            if (result > 0) {
                this.period = result * 1000;
            } else {
                LOG.info("[WSF-Core] The parameter period config error, Use the default value: {}.", (Object)this.period);
            }
        }
        catch (NumberFormatException ex) {
            LOG.info("[WSF-Core] The parameter period config error, Use the default value: {}.", (Object)this.period);
        }
    }

    public boolean judgeInWhiteIpList() {
        return this.isWhiteList;
    }

    public void fillWhiteIpList(boolean whiteList) {
        this.isWhiteList = whiteList;
    }

    public boolean judgeIllegalIpList() {
        return this.illegalIp;
    }

    public void fillIllegalIpList(boolean illegalIp) {
        this.illegalIp = illegalIp;
    }
}

