/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiryDateMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiryDateMap.class);
    private static final long serialVersionUID = 1L;
    private long expiryTime;
    private final ConcurrentHashMap<K, Long> expiryDateMap = new ConcurrentHashMap();
    private long delayTime;
    private long periodTime;
    private int maxMapSize;
    private transient Timer timer;

    public ExpiryDateMap(long expiryTime, int maxSize) {
        this(16, expiryTime, expiryTime, expiryTime, maxSize);
    }

    private ExpiryDateMap(int initialCapacity, long expiryTime, long delay, long period, int maxSize) {
        super(initialCapacity);
        this.expiryTime = expiryTime;
        this.delayTime = delay;
        this.periodTime = period;
        this.maxMapSize = maxSize;
        final ExpiryDateMap expiryDateMapTemp = this;
        this.timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Set set = expiryDateMapTemp.entrySet();
                set.removeIf(entry -> ExpiryDateMap.this.checkExpiryTime(entry.getKey()));
            }
        };
        this.timer.schedule(task, this.delayTime, this.periodTime);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.maxMapSize < this.expiryDateMap.size() + 1) {
            LOG.warn("[WSF-DosPrecautionFilter] repository map is full, Will be cleaned up.");
            this.expiryDateMap.clear();
            super.clear();
        }
        this.expiryDateMap.putIfAbsent(key, this.expiryTime + System.currentTimeMillis());
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return !this.checkExpiryTime(key) && super.containsKey(key);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().size() == 0;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        if (this.checkExpiryTime(key)) {
            return null;
        }
        return super.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = super.entrySet();
        set.removeIf(entry -> this.checkExpiryTime(entry.getKey()));
        return set;
    }

    private boolean checkExpiryTime(Object key) {
        boolean flag;
        if (!this.expiryDateMap.containsKey(key)) {
            return Boolean.FALSE;
        }
        long expiryTimeForKey = this.expiryDateMap.get(key);
        boolean bl = flag = System.currentTimeMillis() > expiryTimeForKey;
        if (flag) {
            super.remove(key);
            this.expiryDateMap.remove(key);
        }
        return flag;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

