/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileLoadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileLoadUtil.class);

    private FileLoadUtil() {
    }

    /*
     * Loose catch block
     */
    public static String loadFileFromClassPath(String fileName) throws IOException {
        InputStream cstream = null;
        ClassLoader loader = FileLoadUtil.class.getClassLoader();
        if (loader != null) {
            cstream = loader.getResourceAsStream(fileName);
        }
        if (cstream == null) {
            cstream = ClassLoader.getSystemResourceAsStream(fileName);
        }
        if (cstream == null) {
            cstream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        }
        if (cstream != null) {
            StringBuilder result = new StringBuilder();
            try {
                try (InputStreamReader reader = new InputStreamReader(cstream, StandardCharsets.UTF_8);){
                    int tempChar = -1;
                    while ((tempChar = reader.read()) != -1) {
                        result.append((char)tempChar);
                    }
                    String string = result.toString();
                    return string;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    cstream.close();
                }
                catch (IOException e) {
                    LOG.error("[WSF-Core] Fail to close input stream: IOException.");
                }
            }
        }
        return "";
    }
}

