/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import com.huawei.springframework.security.web.util.CoreConstant;
import com.huawei.springframework.security.web.util.EmptyUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPFormatCheckUtil {
    public static boolean isInGatewayIP(String ipScope, String currentIp) {
        if (ipScope == null || currentIp == null) {
            return false;
        }
        if (ipScope.equals(currentIp)) {
            return true;
        }
        long ipCheckValue = IPFormatCheckUtil.convertIp2Number(currentIp);
        if (ipCheckValue == (long)CoreConstant.IP_CONVERT_ERROR_CODE.intValue()) {
            return false;
        }
        String[] ipStage = ipScope.split("-");
        if (ipStage.length < CoreConstant.IP_ADDRESS_SEGMENT_LENGTH) {
            return false;
        }
        long ipStartValue = IPFormatCheckUtil.convertIp2Number(ipStage[0]);
        long ipEndValue = IPFormatCheckUtil.convertIp2Number(ipStage[1]);
        if (ipStartValue == (long)CoreConstant.IP_CONVERT_ERROR_CODE.intValue() || ipEndValue == (long)CoreConstant.IP_CONVERT_ERROR_CODE.intValue()) {
            return false;
        }
        return ipEndValue >= ipCheckValue && ipCheckValue >= ipStartValue;
    }

    public static void checkIpRange(List<String> list) {
        for (String ipStr : list) {
            IPFormatCheckUtil.processParamResult(!IPFormatCheckUtil.isLegalIpRange(ipStr));
        }
    }

    public static int formatNumber(String number, String paramName, int defValue) {
        if (EmptyUtils.isEmpty(number)) {
            return defValue;
        }
        try {
            int result = Integer.parseInt(number);
            if (result > 0) {
                return result;
            }
            throw new NumberFormatException("[WSF-Core] The parameter " + paramName + " config error. :" + number);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("[WSF-Core] The parameter " + paramName + " config error. :" + number + "message" + ex.getMessage());
        }
    }

    public static void fillList(String listStr, List<String> list) {
        if (!EmptyUtils.isEmpty(listStr)) {
            String[] ipArr = listStr.split(",");
            list.addAll(Arrays.asList(ipArr));
        }
    }

    public static void processParamResult(boolean isIllegal) {
        if (isIllegal) {
            throw new IllegalArgumentException("[WSF-Core] Argument filter init value.");
        }
    }

    public static boolean isLegalIpRange(String sourceIpRange) {
        if (!Pattern.matches("^[\\d\\.\\-, ]+$", sourceIpRange)) {
            return false;
        }
        if (sourceIpRange.length() > 2048) {
            return false;
        }
        return IPFormatCheckUtil.checkFilterInitIp(sourceIpRange);
    }

    private static boolean checkFilterInitIp(String sourceIpRange) {
        String[] ipStrArray;
        for (String ipRangeStr : ipStrArray = sourceIpRange.split(",")) {
            if (ipRangeStr.endsWith("-")) {
                return false;
            }
            String[] ipRangeArr = ipRangeStr.split("-");
            if (ipRangeArr.length == 2) {
                if (!IPFormatCheckUtil.checkIpFormat(ipRangeArr[0]) || !IPFormatCheckUtil.checkIpFormat(ipRangeArr[1])) {
                    return false;
                }
                if (IPFormatCheckUtil.compareIP(ipRangeArr[0], ipRangeArr[1])) continue;
                return false;
            }
            if (ipRangeArr.length == 1) {
                if (IPFormatCheckUtil.checkIpFormat(ipRangeArr[0])) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static long convertIp2Number(String ipStr) {
        long result = -1L;
        String[] parts = ipStr.split("\\.");
        if (parts.length == 4) {
            result = (Long.parseLong(parts[0]) << 24) + (Long.parseLong(parts[1]) << 16) + (Long.parseLong(parts[2]) << 8) + Long.parseLong(parts[3]);
        }
        return result;
    }

    private static boolean compareIP(String startIp, String endIp) {
        long endNum;
        long startNum = IPFormatCheckUtil.convertIp2Number(startIp);
        return startNum <= (endNum = IPFormatCheckUtil.convertIp2Number(endIp));
    }

    public static boolean isLegalParams(String requestParam, Pattern pattern) {
        if (EmptyUtils.isEmpty(requestParam)) {
            return true;
        }
        boolean isLegal = false;
        Matcher matcher = pattern.matcher(requestParam);
        if (matcher.matches()) {
            isLegal = true;
        }
        return isLegal;
    }

    public static boolean checkIpFormat(String ipAddress) {
        char[] chs = ipAddress.toCharArray();
        boolean containsDot = false;
        for (char ch : chs) {
            if (ch == '.') {
                containsDot = true;
                continue;
            }
            int digit = Character.digit(ch, 16);
            if (digit != CoreConstant.IP_CONVERT_ERROR_CODE) continue;
            return false;
        }
        return IPFormatCheckUtil.ipCheck(containsDot, ipAddress);
    }

    private static boolean ipCheck(boolean containsDot, String ipAddress) {
        if (containsDot) {
            return IPFormatCheckUtil.ipStringFormatV4Bytes(ipAddress).length != 0;
        }
        return false;
    }

    private static byte[] ipStringFormatV4Bytes(String ipAddress) {
        int colonCount = IPFormatCheckUtil.charCount(ipAddress);
        if (colonCount != 3) {
            return new byte[0];
        }
        byte[] bytes = new byte[4];
        int beginIndex = 0;
        for (int i = 0; i < 4; ++i) {
            int endIndex = ipAddress.indexOf(46, beginIndex);
            if (endIndex == CoreConstant.IP_CONVERT_ERROR_CODE) {
                endIndex = ipAddress.length();
            }
            try {
                bytes[i] = IPFormatCheckUtil.convertV4ToByte(ipAddress.substring(beginIndex, endIndex));
            }
            catch (NumberFormatException ex) {
                return new byte[0];
            }
            beginIndex = endIndex + 1;
        }
        return bytes;
    }

    private static int charCount(String ipAddress) {
        int count = 0;
        for (char cc : ipAddress.toCharArray()) {
            if (cc != '.') continue;
            ++count;
        }
        return count;
    }

    private static byte convertV4ToByte(String ipSegment) {
        int len = ipSegment.length();
        IPFormatCheckUtil.compare(len <= 0 || len > 3);
        IPFormatCheckUtil.compare(len > 1 && ipSegment.startsWith(String.valueOf(0)));
        int val = IPFormatCheckUtil.calculateV4Val(ipSegment);
        IPFormatCheckUtil.compare(val > 255);
        return (byte)val;
    }

    private static void compare(boolean result) {
        if (result) {
            throw new NumberFormatException();
        }
    }

    private static int calculateV4Val(String ipSegment) {
        char[] chs;
        for (char ch : chs = ipSegment.toCharArray()) {
            IPFormatCheckUtil.compare(!Character.isDigit(ch));
        }
        return Integer.parseInt(ipSegment);
    }
}

