/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import com.huawei.springframework.security.web.util.EmptyUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmSwitch {
    private static final Logger LOG = LoggerFactory.getLogger(OmSwitch.class);
    private String resourceFileName = "wsf-om.properties";
    private Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmSwitch(String propertyFile) {
        if (EmptyUtils.hasText(propertyFile)) {
            this.resourceFileName = propertyFile;
        } else {
            LOG.debug("[WSF-Upload] Config properties file path is empty, use default: {}.", (Object)this.resourceFileName);
        }
        LOG.debug("[WSF-Upload] Attempting to load properties file: {}.", (Object)this.resourceFileName);
        try (FileInputStream pStream = new FileInputStream(this.resourceFileName);){
            this.properties.load(pStream);
        }
        catch (IOException e) {
            InputStream cStream = null;
            try {
                if (this.getClass().getClassLoader() != null) {
                    cStream = this.getClass().getClassLoader().getResourceAsStream(this.resourceFileName);
                }
                if (cStream == null) {
                    cStream = ClassLoader.getSystemResourceAsStream(this.resourceFileName);
                }
                if (cStream == null) {
                    cStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resourceFileName);
                }
                if (cStream != null) {
                    this.properties.load(cStream);
                } else {
                    LOG.warn("[WSF-OM] Can't find the om properties file.");
                }
                this.closeStream(cStream);
            }
            catch (IOException ex) {
                LOG.warn("[WSF-OM] Can't find the om properties file.");
            }
            finally {
                this.closeStream(cStream);
            }
        }
        LOG.debug("[WSF-OM] Load properties file success.");
    }

    private void closeStream(InputStream cStream) {
        if (cStream != null) {
            try {
                cStream.close();
            }
            catch (IOException ex) {
                LOG.error("[WSF-OM] Failed to close input stream.");
            }
        }
    }

    public static OmSwitch updateSwitch(String fileName) {
        return OmSwitch.getOmInstance(fileName);
    }

    private static OmSwitch getOmInstance(String fileName) {
        return new OmSwitch(fileName);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

