/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.IPFormatCheckUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAddressUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestAddressUtils.class);
    private static final List<String> HEADER_VALUES = new ArrayList<String>();

    public static String getClientIP(HttpServletRequest request, List<String> headerValues, List<String> ipGatewayList, List<String> ipWhiteList) throws IllegalArgumentException {
        ArrayList<String> currentHeader = new ArrayList<String>();
        RequestAddressUtils.initHeaderValue(headerValues, currentHeader);
        String remoteIP = request.getRemoteAddr();
        remoteIP = RequestAddressUtils.getMultistageReverseProxyIp(remoteIP);
        String headerIP = RequestAddressUtils.getIpFormHeaderKey(request, currentHeader);
        String currentIp = ipGatewayList.size() != 0 ? (RequestAddressUtils.isGatewayIP(remoteIP, ipGatewayList) && headerIP != null ? headerIP : remoteIP) : remoteIP;
        RequestAddressUtils.checkIPAddress(ipWhiteList, currentIp);
        return currentIp;
    }

    private static void checkIPAddress(List<String> ipWhiteList, String currentIp) throws IllegalArgumentException {
        if (!IPFormatCheckUtil.checkIpFormat(currentIp)) {
            logger.error("[WSF-DosPrecautionFilter] CurrentIp is illegal ip.");
            throw new IllegalArgumentException("illegalIp");
        }
        if (RequestAddressUtils.isInWhiteList(currentIp, ipWhiteList)) {
            logger.debug("[WSF-DosPrecautionFilter] CurrentIp is in ip whiteList.");
            throw new IllegalArgumentException("whiteListIp");
        }
    }

    private static void initHeaderValue(List<String> headerValues, List<String> currentHeader) {
        if (!EmptyUtils.isEmpty(headerValues)) {
            currentHeader.addAll(headerValues);
            logger.debug("[WSF-DosPrecautionFilter] Use Custom header value");
        } else {
            currentHeader.addAll(HEADER_VALUES);
            logger.debug("[WSF-DosPrecautionFilter] Use Default header value");
        }
    }

    private static String getIpFormHeaderKey(HttpServletRequest request, List<String> currentHeader) {
        String headerIP = null;
        for (String header : currentHeader) {
            headerIP = request.getHeader(header);
            if (RequestAddressUtils.isUnKnow(headerIP)) continue;
            headerIP = RequestAddressUtils.getMultistageReverseProxyIp(headerIP);
            break;
        }
        return headerIP;
    }

    private static String getMultistageReverseProxyIp(String inputIp) {
        if (inputIp != null && inputIp.contains(",")) {
            String[] ips;
            for (String ip : ips = inputIp.trim().split(",")) {
                if (RequestAddressUtils.isUnKnow(ip)) continue;
                return ip;
            }
        }
        return inputIp;
    }

    private static boolean isUnKnow(String checkString) {
        return RequestAddressUtils.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean isBlank(String str) {
        if (EmptyUtils.isEmpty(str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (RequestAddressUtils.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankChar(char ch) {
        return Character.isWhitespace((int)ch) || Character.isSpaceChar((int)ch);
    }

    private static boolean isInWhiteList(String currentIp, List<String> ipWhiteList) {
        for (String ip : ipWhiteList) {
            if (!IPFormatCheckUtil.isInGatewayIP(String.valueOf(ip), currentIp)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGatewayIP(String remoteIP, List<String> ipGatewayList) {
        if (ipGatewayList.size() != 0) {
            String gatewayIp;
            Iterator<String> it = ipGatewayList.iterator();
            do {
                if (!it.hasNext()) {
                    return false;
                }
                gatewayIp = String.valueOf(it.next());
                if (!gatewayIp.equalsIgnoreCase(remoteIP)) continue;
                return true;
            } while (!IPFormatCheckUtil.isInGatewayIP(gatewayIp, remoteIP));
        }
        return true;
    }

    static {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        HEADER_VALUES.addAll(Arrays.asList(headers));
    }
}

