/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.util;

import com.huawei.springframework.security.web.util.EmptyUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUtils.class);
    private static final Pattern URL_CHAR_WHITELIST = Pattern.compile("^[\\w/][\\.\\w/-]*");
    private static final String UTF_8 = "UTF-8";
    private static String serverName = null;

    private RequestUtils() {
    }

    public static String getServerName(ServletRequest servletRequest) {
        if (EmptyUtils.hasText(serverName)) {
            return serverName;
        }
        return servletRequest.getServerName();
    }

    public static void setServerName(String serverName) {
        RequestUtils.serverName = serverName;
    }

    public static String getNormalizeRequestServletURI(ServletRequest servletRequest) {
        String uri = "";
        try {
            HttpServletRequest httpServletRequest = RequestUtils.requestDowncast(servletRequest);
            uri = RequestUtils.getNormalizeRequestServletURI(httpServletRequest);
        }
        catch (ServletException e) {
            LOG.error("[WSF-Core] Fail to get normalize request uri, please input right http servlet request.");
        }
        return uri;
    }

    public static String getNormalizeRequestServletURI(HttpServletRequest httpServletRequest) {
        String uri = httpServletRequest.getServletPath();
        if (httpServletRequest.getPathInfo() != null) {
            uri = uri + httpServletRequest.getPathInfo();
        }
        return uri;
    }

    public static String getNormalizeRequestServletURI(HttpServletRequest httpServletRequest, boolean urlNormalizeEnable) {
        String uri = httpServletRequest.getServletPath();
        if (httpServletRequest.getPathInfo() != null) {
            uri = uri + httpServletRequest.getPathInfo();
        }
        return RequestUtils.secondaryNormalizeURL(uri, urlNormalizeEnable);
    }

    private static String secondaryNormalizeURL(String url, boolean urlNormalizeEnable) {
        if (!urlNormalizeEnable || EmptyUtils.isEmpty(url)) {
            return url;
        }
        try {
            String uri = new URI(url).normalize().toString();
            uri = URLDecoder.decode(uri, UTF_8);
            Matcher matcher = URL_CHAR_WHITELIST.matcher(uri);
            if (matcher.find()) {
                return matcher.group(0);
            }
            LOG.error("[WSF-Core] invalid path info, please check your request's information.");
            return url;
        }
        catch (URISyntaxException ex) {
            LOG.error("[WSF-Core] Failed to normalizeURL.");
            return url;
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("[WSF-Core] unsupported encoding.");
            return url;
        }
    }

    public static String getNormalizeRequestURI(ServletRequest servletRequest) {
        return servletRequest.getServletContext().getContextPath() + RequestUtils.getNormalizeRequestServletURI(servletRequest);
    }

    public static String getNormalizeRequestURL(ServletRequest servletRequest) {
        StringBuilder builder = new StringBuilder();
        builder.append(servletRequest.getScheme()).append("://").append(RequestUtils.getServerName(servletRequest));
        builder.append(RequestUtils.getServerPort(servletRequest));
        builder.append(RequestUtils.getNormalizeRequestURI(servletRequest));
        return builder.toString();
    }

    public static String getServerPort(ServletRequest servletRequest) {
        int serverPort = servletRequest.getServerPort();
        if (serverPort != 80 && serverPort != 443) {
            return ":" + serverPort;
        }
        return "";
    }

    public static String getLocalDomain(HttpServletRequest servletRequest) {
        return RequestUtils.getServerName((ServletRequest)servletRequest) + RequestUtils.getServerPort((ServletRequest)servletRequest);
    }

    public static HttpServletRequest requestDowncast(ServletRequest servletRequest) throws ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            return (HttpServletRequest)servletRequest;
        }
        throw new ServletException("[WSF-Core] ServletRequest downcast to HttpServletRequest failed");
    }

    public static HttpServletResponse responseDowncast(ServletResponse servletResponse) throws ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            return (HttpServletResponse)servletResponse;
        }
        throw new ServletException("[WSF-Core] ServletResponse downcast to HttpServletResponse failed");
    }
}

