/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.customsort.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.mapper.CustomSortMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class CustomSortDaoHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CustomSortDaoHandler.class);

    private CustomSortDaoHandler() {
    }

    public static CustomSortDaoHandler getInstance() {
        return CustomSortDaoHandlerHolder.INSTANCE;
    }

    public void createTb(CustomSortMapper customSortMapper) {
        try {
            customSortMapper.createTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'CUSTOMSORT' already exists or create error.", e);
        }
    }

    public boolean add(CustomSortMapper customSortMapper, CustomSortDo customSortDo) {
        try {
            customSortMapper.add(customSortDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add Error", e);
            return false;
        }
        return true;
    }

    public boolean addBatch(CustomSortMapper customSortMapper, List<CustomSortDo> customSortDoList) {
        try {
            customSortMapper.addBatch(customSortDoList);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "CustomSortDaoHandler.addBatch Error", e);
            return false;
        }
        return true;
    }

    public boolean del(CustomSortMapper customSortMapper, String nodeId) {
        try {
            customSortMapper.del(nodeId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del Error", e);
            return false;
        }
        return true;
    }

    public boolean delByDocId(CustomSortMapper customSortMapper, String docId) {
        try {
            customSortMapper.delByDocId(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delByDocId Error", e);
            return false;
        }
        return true;
    }

    public boolean delAll(CustomSortMapper customSortMapper) {
        try {
            customSortMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delAll Error", e);
            return false;
        }
        return true;
    }

    public CustomSortDo getByDocId(CustomSortMapper customSortMapper, String docId) {
        CustomSortDo customSortDo = null;
        try {
            customSortDo = customSortMapper.getByDocId(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByDocId Error", e);
        }
        return customSortDo;
    }

    public List<CustomSortDo> getFolder(CustomSortMapper customSortMapper) {
        ArrayList<CustomSortDo> customSortDoList = new ArrayList();
        try {
            customSortDoList = customSortMapper.getFolder();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getFolder ERROR", e);
        }
        return customSortDoList;
    }

    public CustomSortDo getByNodeId(CustomSortMapper customSortMapper, String nodeId) {
        CustomSortDo customSortDo = null;
        try {
            customSortDo = customSortMapper.getByNodeId(nodeId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByNodeId ERROR", e);
        }
        return customSortDo;
    }

    public List<CustomSortDo> getChildNode(CustomSortMapper customSortMapper, String parentId, String type) {
        ArrayList<CustomSortDo> customSortDoList = new ArrayList<CustomSortDo>();
        try {
            customSortDoList.addAll(customSortMapper.getChildNode(parentId, type));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getChildNode ERROR", e);
        }
        return customSortDoList;
    }

    public List<CustomSortDo> getNodeTree(CustomSortMapper customSortMapper, String parentId) {
        ArrayList<CustomSortDo> customSortDoList = new ArrayList<CustomSortDo>();
        try {
            customSortDoList.addAll(customSortMapper.getNodeTree(parentId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getChildNode ERROR", e);
        }
        return customSortDoList;
    }

    public List<CustomSortDo> getOldData(CustomSortMapper customSortMapper, int beginIndex, int perPageNum) {
        ArrayList<CustomSortDo> customSortDoList = new ArrayList<CustomSortDo>();
        try {
            customSortDoList.addAll(customSortMapper.getCustomOldData(beginIndex, perPageNum));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getOldData ERROR", e);
        }
        return customSortDoList;
    }

    public int getOldDataSize(CustomSortMapper customSortMapper) {
        int size = 0;
        try {
            size = customSortMapper.getCustomOldDataSize();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "getOldDataSize ERROR", e);
        }
        return size;
    }

    public void modifyName(CustomSortMapper customSortMapper, String nodeId, String name, String modifyTime) {
        try {
            customSortMapper.modifyName(nodeId, name, modifyTime);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "modifyName ERROR", e);
        }
    }

    public void modifyParentNode(CustomSortMapper customSortMapper, String nodeId, String parentId, String modifyTime) {
        try {
            customSortMapper.modifyParentNode(nodeId, parentId, modifyTime);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "modifyParentNode ERROR", e);
        }
    }

    public List<String> getFixedNameFolder(CustomSortMapper customSortMapper, String name, String parentId) {
        ArrayList<String> nameList = new ArrayList();
        try {
            nameList = customSortMapper.getFixedNameFolder(name, parentId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getFixedNameFolder ERROR", e);
        }
        return nameList;
    }

    public Set<String> getAllDocId(CustomSortMapper customSortMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(customSortMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    public boolean updateExpand(CustomSortMapper customSortMapper, String nodeId, boolean isExpand) {
        try {
            customSortMapper.updateExpand(nodeId, isExpand);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateExpand Error", e);
            return false;
        }
        return true;
    }

    public boolean updateFlag(CustomSortMapper customSortMapper, String docId, boolean isUpdate) {
        try {
            customSortMapper.updateFlag(docId, isUpdate);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateFlag Error", e);
            return false;
        }
        return true;
    }

    public boolean updateVerify(CustomSortMapper customSortMapper, String docId, String verify) {
        try {
            customSortMapper.updateVerify(docId, verify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateVerify Error", e);
            return false;
        }
        return true;
    }

    public boolean updateIndexProgress(CustomSortMapper customSortMapper, String docId, String indexProgress) {
        try {
            customSortMapper.updateIndexProgress(docId, indexProgress);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateVerify Error", e);
            return false;
        }
        return true;
    }

    public boolean delOldData(CustomSortMapper customSortMapper) {
        try {
            customSortMapper.delCustomOldData();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delOldData Error", e);
            return false;
        }
        return true;
    }

    public List<CustomSortDo> getCustomDoList(CustomSortMapper customSortMapper, String docId) {
        ArrayList<CustomSortDo> customSortDoList = new ArrayList();
        try {
            customSortDoList = customSortMapper.getCustomDoList(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getCustomDoList ERROR", e);
        }
        return customSortDoList;
    }

    private static class CustomSortDaoHandlerHolder {
        private static final CustomSortDaoHandler INSTANCE = new CustomSortDaoHandler();

        private CustomSortDaoHandlerHolder() {
        }
    }
}

