/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.customsort.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icslite.customsort.dao.CustomSortDaoHandler;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.mapper.CustomSortMapper;
import com.huawei.support.icslite.customsort.service.CustomSortService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomSortServiceHandler
extends BasePool<CustomSortDo>
implements CustomSortService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CustomSortServiceHandler.class);
    private static final CustomSortMapper CUSTOM_SORT_MAPPER = (CustomSortMapper)DbMapperUtils.getMapper(CustomSortMapper.class);
    private static final int PER_PAGE_NUMBER = 100;

    private CustomSortServiceHandler() {
    }

    protected void createPool(String nodeId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "create key" + nodeId);
        CustomSortDo customSortDo = CustomSortDaoHandler.getInstance().getByNodeId(CUSTOM_SORT_MAPPER, nodeId);
        super.addPool(nodeId, (Object)customSortDo);
    }

    public static CustomSortServiceHandler getInstance() {
        return CustomSortServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        CustomSortDaoHandler.getInstance().createTb(CUSTOM_SORT_MAPPER);
        int oldDataSize = CustomSortDaoHandler.getInstance().getOldDataSize(CUSTOM_SORT_MAPPER);
        if (oldDataSize == 0) {
            return;
        }
        int minIndex = 0;
        while (oldDataSize - minIndex > 0) {
            List<CustomSortDo> customSortDoList = CustomSortDaoHandler.getInstance().getOldData(CUSTOM_SORT_MAPPER, minIndex, 100);
            minIndex += 100;
            for (CustomSortDo customSortDo : customSortDoList) {
                CustomSortDaoHandler.getInstance().add(CUSTOM_SORT_MAPPER, customSortDo);
            }
        }
        CustomSortDaoHandler.getInstance().delOldData(CUSTOM_SORT_MAPPER);
    }

    @Override
    public boolean add(CustomSortDo customSortDo) {
        if (customSortDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "customSortDo is null.");
            return false;
        }
        return CustomSortDaoHandler.getInstance().add(CUSTOM_SORT_MAPPER, customSortDo);
    }

    @Override
    public boolean addBatch(List<CustomSortDo> customSortDoList) {
        if (CollectionUtils.isEmpty(customSortDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "customSortDoList is empty.");
            return false;
        }
        return CustomSortDaoHandler.getInstance().addBatch(CUSTOM_SORT_MAPPER, customSortDoList);
    }

    @Override
    public boolean del(String nodeId) {
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nodeId is Empty.");
            return false;
        }
        this.delPool(nodeId);
        return CustomSortDaoHandler.getInstance().del(CUSTOM_SORT_MAPPER, nodeId);
    }

    @Override
    public boolean delByDocId(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty.");
            return false;
        }
        this.delPool(docId);
        return CustomSortDaoHandler.getInstance().delByDocId(CUSTOM_SORT_MAPPER, docId);
    }

    @Override
    public boolean delAll() {
        return CustomSortDaoHandler.getInstance().delAll(CUSTOM_SORT_MAPPER);
    }

    @Override
    public CustomSortDo getByDocId(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty.");
            return null;
        }
        return CustomSortDaoHandler.getInstance().getByDocId(CUSTOM_SORT_MAPPER, docId);
    }

    @Override
    public List<CustomSortDo> getFolder() {
        return CustomSortDaoHandler.getInstance().getFolder(CUSTOM_SORT_MAPPER);
    }

    @Override
    public CustomSortDo getByNodeId(String nodeId) {
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nodeId is Empty.");
            return null;
        }
        return (CustomSortDo)this.getPool(nodeId);
    }

    @Override
    public List<CustomSortDo> getChildNode(String parentId, String type) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{parentId, type})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "parentId or type is blank.");
            return Collections.emptyList();
        }
        return CustomSortDaoHandler.getInstance().getChildNode(CUSTOM_SORT_MAPPER, parentId, type);
    }

    @Override
    public List<CustomSortDo> getNodeTree(String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "parentId is blank.");
            return Collections.emptyList();
        }
        return CustomSortDaoHandler.getInstance().getNodeTree(CUSTOM_SORT_MAPPER, parentId);
    }

    @Override
    public void modifyName(String nodeId, String name, String modifyTime) {
        if (StringUtils.isEmpty((CharSequence)nodeId) || StringUtils.isEmpty((CharSequence)modifyTime)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nodeId or is modifyTime Empty.");
            return;
        }
        CustomSortDo customSortDo = (CustomSortDo)this.getPool(nodeId);
        if (customSortDo != null) {
            customSortDo.setName(name);
            customSortDo.setModifyTime(modifyTime);
        }
        CustomSortDaoHandler.getInstance().modifyName(CUSTOM_SORT_MAPPER, nodeId, name, modifyTime);
    }

    @Override
    public void modifyParentNode(String nodeId, String parentId, String modifyTime) {
        if (StringUtils.isEmpty((CharSequence)parentId) || StringUtils.isEmpty((CharSequence)nodeId) || StringUtils.isEmpty((CharSequence)modifyTime)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "parentId \u3001nodeId or is modifyTime Empty.");
            return;
        }
        CustomSortDo customSortDo = (CustomSortDo)this.getPool(nodeId);
        if (customSortDo != null) {
            customSortDo.setParentId(parentId);
            customSortDo.setModifyTime(modifyTime);
        }
        CustomSortDaoHandler.getInstance().modifyParentNode(CUSTOM_SORT_MAPPER, nodeId, parentId, modifyTime);
    }

    @Override
    public List<String> getFixedNameFolder(String name, String parentId) {
        return CustomSortDaoHandler.getInstance().getFixedNameFolder(CUSTOM_SORT_MAPPER, name, parentId);
    }

    @Override
    public Set<String> getAllDocId() {
        return CustomSortDaoHandler.getInstance().getAllDocId(CUSTOM_SORT_MAPPER);
    }

    @Override
    public boolean updateExpand(String nodeId, boolean isExpand) {
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nodeId Empty.");
            return false;
        }
        CustomSortDo customSortDo = (CustomSortDo)this.getPool(nodeId);
        if (customSortDo != null) {
            customSortDo.setExpand(isExpand);
        }
        return CustomSortDaoHandler.getInstance().updateExpand(CUSTOM_SORT_MAPPER, nodeId, isExpand);
    }

    @Override
    public boolean updateFlag(String docId, boolean isUpdate) {
        return CustomSortDaoHandler.getInstance().updateFlag(CUSTOM_SORT_MAPPER, docId, isUpdate);
    }

    @Override
    public boolean updateVerify(String docId, String verify) {
        return CustomSortDaoHandler.getInstance().updateVerify(CUSTOM_SORT_MAPPER, docId, verify);
    }

    @Override
    public boolean updateIndexProgress(String docId, String indexProgress) {
        return CustomSortDaoHandler.getInstance().updateIndexProgress(CUSTOM_SORT_MAPPER, docId, indexProgress);
    }

    @Override
    public List<CustomSortDo> getCustomDoList(String docId) {
        return CustomSortDaoHandler.getInstance().getCustomDoList(CUSTOM_SORT_MAPPER, docId);
    }

    private static class CustomSortServiceHandlerHolder {
        private static final CustomSortServiceHandler INSTANCE = new CustomSortServiceHandler();

        private CustomSortServiceHandlerHolder() {
        }
    }
}

