/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ICheckedFunction;
import com.huawei.kmc.common.propsfunc.AutoUpdateMkFunc;
import com.huawei.kmc.common.propsfunc.DomainCountFunc;
import com.huawei.kmc.common.propsfunc.GeneralPathFunc;
import com.huawei.kmc.common.propsfunc.HmacFunc;
import com.huawei.kmc.common.propsfunc.InnerHashFunc;
import com.huawei.kmc.common.propsfunc.InnerHmacFunc;
import com.huawei.kmc.common.propsfunc.InnerKdfFunc;
import com.huawei.kmc.common.propsfunc.InnerSymmFunc;
import com.huawei.kmc.common.propsfunc.KeyIterFunc;
import com.huawei.kmc.common.propsfunc.LifeTimeFunc;
import com.huawei.kmc.common.propsfunc.RoleFunc;
import com.huawei.kmc.common.propsfunc.SdpAlgorithmFunc;
import com.huawei.kmc.common.propsfunc.SemKeyFunc;
import com.huawei.kmc.common.propsfunc.UnixFileAccessFunc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static void checkCryptoProps(Properties filterProps) throws AppException {
        Map<String, ICheckedFunction<String, String, Boolean, AppException>> funcMap = ConfigUtils.buildFuncMap();
        Set<String> keySet = filterProps.stringPropertyNames();
        for (String key : keySet) {
            if (!funcMap.containsKey(key)) {
                throw new AppException("funcMap not containsKey funcation, key: " + key);
            }
            ICheckedFunction<String, String, Boolean, AppException> funcRunner = funcMap.get(key);
            funcRunner.apply(key, filterProps.getProperty(key));
        }
    }

    public static boolean checkLifetimeDays(int lifeTimeDays) throws AppException {
        Map<String, ICheckedFunction<String, String, Boolean, AppException>> funcMap = ConfigUtils.buildFuncMap();
        if (!funcMap.containsKey("crypt_key_lifetime_days")) {
            throw new AppException("param map not contains crypt_key_lifetime_days function.");
        }
        ICheckedFunction<String, String, Boolean, AppException> funcRunner = funcMap.get("crypt_key_lifetime_days");
        return funcRunner.apply("crypt_key_lifetime_days", String.valueOf(lifeTimeDays));
    }

    private static Map<String, ICheckedFunction<String, String, Boolean, AppException>> buildFuncMap() {
        HashMap<String, ICheckedFunction<String, String, Boolean, AppException>> funcMap = new HashMap<String, ICheckedFunction<String, String, Boolean, AppException>>();
        funcMap.put("domain_count", new DomainCountFunc());
        funcMap.put("primary_key_store_file", new GeneralPathFunc());
        funcMap.put("standby_key_store_file", new GeneralPathFunc());
        funcMap.put("auto_update_mk_enabled", new AutoUpdateMkFunc());
        funcMap.put("crypt_key_lifetime_days", new LifeTimeFunc());
        funcMap.put("crypt_component_role", new RoleFunc());
        funcMap.put("crypt_symmetric_algorithm", new SdpAlgorithmFunc());
        funcMap.put("crypt_hamc_algorithm", new HmacFunc());
        funcMap.put("crypt_process_perms", new UnixFileAccessFunc());
        funcMap.put("crypt_proc_sem_key", new SemKeyFunc());
        funcMap.put("inner_crypt_symmetric_algorithm", new InnerSymmFunc());
        funcMap.put("inner_crypt_hash_algorithm", new InnerHashFunc());
        funcMap.put("inner_crypt_hmac_algorithm", new InnerHmacFunc());
        funcMap.put("inner_crypt_kdf_algorithm", new InnerKdfFunc());
        funcMap.put("work_key_iter", new KeyIterFunc());
        funcMap.put("root_key_iter", new KeyIterFunc());
        return funcMap;
    }

    private static Set<String> getRequiredKmcPropsSet() {
        HashSet<String> requiredSet = new HashSet<String>();
        requiredSet.add("primary_key_store_file");
        requiredSet.add("standby_key_store_file");
        requiredSet.add("domain_count");
        return requiredSet;
    }

    private static Set<String> getOptionalKmcPropsSet() {
        HashSet<String> optionalSet = new HashSet<String>();
        optionalSet.add("crypt_key_lifetime_days");
        optionalSet.add("auto_update_mk_enabled");
        optionalSet.add("crypt_component_role");
        optionalSet.add("crypt_hamc_algorithm");
        optionalSet.add("crypt_symmetric_algorithm");
        optionalSet.add("crypt_process_perms");
        optionalSet.add("crypt_proc_sem_key");
        optionalSet.add("inner_crypt_symmetric_algorithm");
        optionalSet.add("inner_crypt_hmac_algorithm");
        optionalSet.add("inner_crypt_hash_algorithm");
        optionalSet.add("inner_crypt_kdf_algorithm");
        optionalSet.add("work_key_iter");
        optionalSet.add("root_key_iter");
        return optionalSet;
    }

    public static Properties checkIntegrityAndFilterProp(Properties props) throws AppException {
        if (props == null || props.size() == 0) {
            throw new AppException("props cannot be null.");
        }
        Set<String> required = ConfigUtils.getRequiredKmcPropsSet();
        Set<String> optional = ConfigUtils.getOptionalKmcPropsSet();
        int requiredCount = 0;
        Properties filterProperties = new Properties();
        Set<String> keySet = props.stringPropertyNames();
        for (String key : keySet) {
            if (props.get(key) == null) {
                throw new AppException("properties value invalid. it's key: " + key);
            }
            if (!required.contains(key)) continue;
            ++requiredCount;
        }
        if (requiredCount == required.size()) {
            for (String requiredProp : required) {
                if (!props.containsKey(requiredProp)) continue;
                filterProperties.put(requiredProp, props.get(requiredProp));
            }
            for (String optionalProp : optional) {
                if (!props.containsKey(optionalProp)) continue;
                filterProperties.put(optionalProp, props.get(optionalProp));
            }
            return filterProperties;
        }
        for (String requiredKey : required) {
            if (props.containsKey(requiredKey)) continue;
            throw new AppException("Missing required key : " + requiredKey);
        }
        return filterProperties;
    }
}

