/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum HmacAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    HMAC_SHA256("HMAC_SHA256", 2052),
    HMAC_SHA384("HMAC_SHA384", 2053),
    HMAC_SHA512("HMAC_SHA512", 2054),
    HMAC_SM3("HMAC_SM3", 2055);

    private String hmac;
    private int value;

    private HmacAlgorithm(String hmac, int value) {
        this.hmac = hmac;
        this.value = value;
    }

    public static HmacAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        HmacAlgorithm algTemp = null;
        try {
            algTemp = HmacAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getSdpAlg() {
        return this.hmac;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

