/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum InnerHmacAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    HMAC_SHA256("HMAC_SHA256", 2052),
    HMAC_SM3("HMAC_SM3", 2055);

    private String hmacAlg;
    private int value;

    private InnerHmacAlgorithm(String hmacAlg, int value) {
        this.hmacAlg = hmacAlg;
        this.value = value;
    }

    public static InnerHmacAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        InnerHmacAlgorithm algTemp = null;
        try {
            algTemp = InnerHmacAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getHmacAlg() {
        return this.hmacAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

