/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum SdpAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    AES128_CBC("AES128_CBC", 5),
    AES256_CBC("AES256_CBC", 7),
    AES128_GCM("AES128_GCM", 8),
    AES256_GCM("AES256_GCM", 9),
    SM4_CBC("SM4_CBC", 10),
    SM4_CTR("SM4_CTR", 11);

    private String sdpAlg;
    private int value;

    private SdpAlgorithm(String sdpAlg, int value) {
        this.sdpAlg = sdpAlg;
        this.value = value;
    }

    public static SdpAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        SdpAlgorithm algTemp = null;
        try {
            algTemp = SdpAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getSdpAlg() {
        return this.sdpAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

