/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.crypt;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.CommonUtils;
import com.huawei.kmc.common.ConfigUtils;
import com.huawei.kmc.common.Constant;
import com.huawei.kmc.common.Errno;
import com.huawei.kmc.common.HmacAlgorithm;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.common.InnerHashAlgorithm;
import com.huawei.kmc.common.InnerHmacAlgorithm;
import com.huawei.kmc.common.InnerKdfAlgorithm;
import com.huawei.kmc.common.InnerSymmAlgorithm;
import com.huawei.kmc.common.JNIRefObj;
import com.huawei.kmc.common.KmcMkInfo;
import com.huawei.kmc.common.SdpAlgorithm;
import com.huawei.kmc.entity.KmcExportCfg;
import com.huawei.kmc.entity.KmcImportCfg;
import com.huawei.kmc.entity.KmcInitConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class CryptoAPI {
    static final String KMC_VERSION = "KMC 21.0.1";
    static final String DEFAULT_APILIB_NAME = "kmcjni";
    private static ILogger logger = null;
    private static INotifyCallback notifyCallback = null;
    private static volatile CryptoAPI instance = null;
    private static volatile InitStage stage = InitStage.UNINIT;
    private static KmcInitConfig kmcInitConfig = null;
    private static volatile Properties globalProperties = new Properties();
    private static final Object lock = new Object();
    private int defaultDomainId = 0;

    private CryptoAPI() {
    }

    private static void loadLibs() throws AppException {
        try {
            System.loadLibrary(DEFAULT_APILIB_NAME);
        }
        catch (NullPointerException | SecurityException | UnsatisfiedLinkError e) {
            throw new AppException("load library failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoAPI getInstance() {
        if (instance != null) return instance;
        Class<CryptoAPI> clazz = CryptoAPI.class;
        synchronized (CryptoAPI.class) {
            if (instance != null) return instance;
            instance = new CryptoAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Properties getProperties() {
        return globalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLifetimeDays(int updateLifeDays) throws AppException {
        ConfigUtils.checkLifetimeDays(updateLifeDays);
        Object object = lock;
        synchronized (object) {
            globalProperties.put("crypt_key_lifetime_days", (Object)updateLifeDays);
        }
    }

    public static int getInitStage() {
        return stage.getValue();
    }

    private native int keInitialize(KmcInitConfig var1);

    private native int keFinalize();

    private native int keEncryptByDomain(int var1, byte[] var2, JNIRefObj var3);

    private native int keDecryptByDomain(int var1, byte[] var2, JNIRefObj var3);

    private native int keReEncryptByDomain(int var1, byte[] var2, JNIRefObj var3);

    private native int keActiveNewKey(int var1);

    private native int keGenSecKey(int var1, JNIRefObj var2);

    private native int keGenSecByteKey(int var1, JNIRefObj var2);

    private native int keRegisterKey(int var1, int var2, byte[] var3);

    private native int keRegisterByteKey(int var1, int var2, byte[] var3);

    private native int keGetKeyByID(int var1, int var2, JNIRefObj var3, int var4);

    private native int keGetMaxMkID(int var1, JNIRefObj var2);

    private native int keIsExistMkID(int var1, int var2, JNIRefObj var3);

    private native int keHmacByDomain(int var1, byte[] var2, JNIRefObj var3);

    private native int keHmacVerifyByDomain(int var1, byte[] var2, byte[] var3, JNIRefObj var4);

    private native int keImportMkFile(byte[] var1, byte[] var2);

    private native int keExportMkFile(byte[] var1, byte[] var2);

    private native void kePrintAllInfoToLog();

    private native int keCheckAndUpdateMk(int var1, int var2);

    private native int keRemoveKeyByID(int var1, int var2);

    private native int keGetMkCount();

    private native KmcMkInfo keGetMkInfo(int var1);

    private native int keRefreshMkMask();

    private native int keUpdateRootKey();

    private native int keSecEraseKeystore();

    private static native void keSetLogLevel(int var0);

    private native int keImportKsf(KmcImportCfg var1);

    private native int keExportKsf(KmcExportCfg var1);

    private static KmcInitConfig buildConfig() {
        String primaryKeyStoreFile = globalProperties.getProperty("primary_key_store_file", "");
        String standbyKeyStoreFile = globalProperties.getProperty("standby_key_store_file", "");
        String domainCount = globalProperties.getProperty("domain_count", "");
        String roleParam = globalProperties.getProperty("crypt_component_role", String.valueOf(1));
        String processPerms = globalProperties.getProperty("crypt_process_perms", "0600");
        String symmetricAlg = globalProperties.getProperty("crypt_symmetric_algorithm", "AES256_GCM");
        String hmacAlg = globalProperties.getProperty("crypt_hamc_algorithm", "HMAC_SHA256");
        String innerSymmAlg = globalProperties.getProperty("inner_crypt_symmetric_algorithm", "AES256_GCM");
        String innerHmacAlg = globalProperties.getProperty("inner_crypt_hmac_algorithm", "HMAC_SHA256");
        String innerHashAlg = globalProperties.getProperty("inner_crypt_hash_algorithm", "HASH_SHA256");
        String innerKdfAlg = globalProperties.getProperty("inner_crypt_kdf_algorithm", "PBKDF2_HMAC_SHA256");
        String workKeyIter = globalProperties.getProperty("work_key_iter", String.valueOf(1));
        String rootKeyIter = globalProperties.getProperty("root_key_iter", String.valueOf(10000));
        int role = Integer.parseInt(roleParam);
        KmcInitConfig.Role kmcRole = role == 1 ? KmcInitConfig.Role.ROLE_MASTER : KmcInitConfig.Role.ROLE_AGENT;
        String semProp = globalProperties.getProperty("crypt_proc_sem_key");
        String semConfig = semProp == null ? "1227" : semProp;
        Integer semBase = Integer.valueOf("20160000", 16);
        Integer semKey = semBase + Integer.valueOf(semConfig, 16);
        KmcInitConfig initConfig = new KmcInitConfig();
        initConfig.setPrimaryKeyStoreFile(primaryKeyStoreFile);
        initConfig.setStandbyKeyStoreFile(standbyKeyStoreFile);
        initConfig.setRole(kmcRole);
        initConfig.setDomainCount(Integer.parseInt(domainCount));
        initConfig.setProcLockPerm(Integer.valueOf(processPerms, 8));
        initConfig.setSdpAlgId(SdpAlgorithm.searchByName(symmetricAlg).getValue());
        initConfig.setHmacAlgId(HmacAlgorithm.searchByName(hmacAlg).getValue());
        initConfig.setInnerSymmAlgId(InnerSymmAlgorithm.searchByName(innerSymmAlg).getValue());
        initConfig.setInnerHashAlgId(InnerHashAlgorithm.searchByName(innerHashAlg).getValue());
        initConfig.setInnerHmacAlgId(InnerHmacAlgorithm.searchByName(innerHmacAlg).getValue());
        initConfig.setInnerKdfAlgId(InnerKdfAlgorithm.searchByName(innerKdfAlg).getValue());
        initConfig.setWorkKeyIter(Integer.parseInt(workKeyIter));
        initConfig.setRootKeyIter(Integer.parseInt(rootKeyIter));
        initConfig.setSemKey(semKey);
        initConfig.setExtendProperties(globalProperties);
        return initConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties configProps) throws AppException {
        if (configProps == null || configProps.size() == 0) {
            throw new AppException("config properties cannot be null.");
        }
        Properties filterProps = ConfigUtils.checkIntegrityAndFilterProp(configProps);
        Object object = lock;
        synchronized (object) {
            globalProperties.clear();
            globalProperties.putAll((Map<?, ?>)filterProps);
            try {
                ConfigUtils.checkCryptoProps(globalProperties);
            }
            catch (AppException e) {
                CryptoAPI.getLogger().error("check property error details");
                throw e;
            }
            CryptoAPI.getLogger().info("init component properties size: " + globalProperties.size());
            KmcInitConfig initConfig = CryptoAPI.buildConfig();
            initConfig.setExtendProperties(globalProperties);
            this.initCryptoComponent(initConfig);
        }
    }

    private void initCryptoComponent(KmcInitConfig config) throws AppException {
        int result;
        CryptoAPI.getLogger().info("kmc initialize stage: " + ((Object)((Object)stage)).getClass().getSimpleName());
        Optional.ofNullable(config).orElseThrow(() -> new AppException("config cannot be null."));
        if (kmcInitConfig == null) {
            kmcInitConfig = config;
        }
        if ((result = this.kmcInitialize(config)) != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("kmcInitialize failed result is : " + result);
        }
    }

    private int kmcInitialize(KmcInitConfig config) throws AppException {
        Optional.ofNullable(config).orElseThrow(() -> new AppException("config cannot be null."));
        if (stage == InitStage.INIT_KMC_DONE) {
            CryptoAPI.getLogger().error("api kmc initialize failed, already init before");
            throw new AppException("already init before " + (Object)((Object)stage));
        }
        if (stage != InitStage.JNI_LOADED) {
            throw new AppException("JNI not loaded check your env");
        }
        CryptoAPI.getLogger().info("before kmc initdone.");
        int result = this.keInitialize(config);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            stage = InitStage.INIT_KMC_DONE;
        }
        CryptoAPI.getLogger().info("Kmc init done.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalized() throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keFinalize();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("finalize failed result is : " + result);
            }
            stage = InitStage.JNI_LOADED;
            kmcInitConfig = null;
            globalProperties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ILogger getLogger() {
        Object object = lock;
        synchronized (object) {
            if (logger != null) {
                return logger;
            }
            logger = new ILogger(){

                @Override
                public void error(String message) {
                }

                @Override
                public void warn(String message) {
                }

                @Override
                public void info(String message) {
                }

                @Override
                public void debug(String message) {
                }

                @Override
                public void trace(String message) {
                }
            };
        }
        return logger;
    }

    private void checkInit() throws AppException {
        if (stage != InitStage.INIT_KMC_DONE) {
            throw new AppException("Not initialized, the stage is: " + (Object)((Object)stage));
        }
    }

    public byte[] encrypt(byte[] plainText) throws AppException {
        return this.encrypt(this.defaultDomainId, plainText);
    }

    public byte[] encrypt(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        if (plainText == null || plainText.length == 0) {
            throw new AppException("plainText cannot be null.");
        }
        if (kmcInitConfig == null) {
            throw new AppException("kmcInitConfig should be init.");
        }
        if (CommonUtils.checkAutoUpdateMk(globalProperties) && KmcInitConfig.Role.ROLE_MASTER == kmcInitConfig.getRole()) {
            String updateMkProp = globalProperties.getProperty("crypt_key_lifetime_days", null);
            String updateDays = Optional.ofNullable(updateMkProp).orElse((String)((Object)Integer.valueOf(180)));
            int lifeDays = Integer.parseInt(updateDays.toString());
            logger.debug("lifeDays : " + lifeDays);
            this.checkAndUpdateMk(domainID, lifeDays);
        }
        byte[] cipherText = null;
        JNIRefObj refCipherText = new JNIRefObj();
        int result = this.keEncryptByDomain(domainID, plainText, refCipherText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Encrypt in domain " + domainID + " failed,result=" + result);
        }
        cipherText = refCipherText.getByteArray();
        return cipherText;
    }

    public byte[] decrypt(byte[] cipherText) throws AppException {
        return this.decrypt(this.defaultDomainId, cipherText);
    }

    public byte[] decrypt(int domainID, byte[] cipherText) throws AppException {
        this.checkInit();
        if (cipherText == null || cipherText.length == 0) {
            throw new AppException("The cipherText cannot be null.");
        }
        JNIRefObj refPlainText = new JNIRefObj();
        int result = this.keDecryptByDomain(domainID, cipherText, refPlainText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Decrypt in " + domainID + "  failed,result=" + result);
        }
        return refPlainText.byteArr;
    }

    public byte[] reEncrypt(byte[] cipherText) throws AppException {
        return this.reEncrypt(this.defaultDomainId, cipherText);
    }

    public byte[] reEncrypt(int domainID, byte[] cipherText) throws AppException {
        this.checkInit();
        if (cipherText == null || cipherText.length == 0) {
            throw new AppException("cipherText cannot be null.");
        }
        JNIRefObj refNewCipherText = new JNIRefObj();
        int result = this.keReEncryptByDomain(domainID, cipherText, refNewCipherText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("ReEncrypt in domain " + domainID + " failed,result=" + result);
        }
        return refNewCipherText.getByteArray();
    }

    public void activeNewKey() throws AppException {
        this.activeNewKey(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeNewKey(int domainID) throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keActiveNewKey(domainID);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("ActiveNewKey for domain " + domainID + " failed,result=" + result);
            }
        }
    }

    public byte[] genSecBase64Key(int keyLen) throws AppException {
        this.checkInit();
        JNIRefObj refKey = new JNIRefObj();
        int result = this.keGenSecKey(keyLen, refKey);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("genSecKey failed,result=" + result);
        }
        return refKey.byteArr;
    }

    public byte[] genSecByteKey() throws AppException {
        return this.genSecByteKey(32);
    }

    public byte[] genSecByteKey(int keyLen) throws AppException {
        this.checkInit();
        byte[] key = null;
        JNIRefObj refKey = new JNIRefObj();
        int result = this.keGenSecByteKey(keyLen, refKey);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("GenSecByteKey failed,result=" + result);
        }
        key = refKey.getByteArray();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            if (domainID == 0) {
                throw new AppException("Can't register key in default domain0");
            }
            if (key == null || key.length == 0) {
                throw new AppException("The key cannot be null.");
            }
            int result = this.keRegisterKey(domainID, keyID, key);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("RegisterKey failed,result=" + result);
            }
        }
    }

    public void registerByteKey(int domainID, byte[] key) throws AppException {
        this.registerByteKey(domainID, 0, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerByteKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            if (domainID == 0) {
                throw new AppException("Can't register key in default domain0");
            }
            if (key == null || key.length == 0) {
                throw new AppException("The key cannot be null.");
            }
            int result = this.keRegisterByteKey(domainID, keyID, key);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("RegisterByteKey failed,result=" + result);
            }
        }
    }

    public String getActiveEncodeKey(int domainID) throws AppException {
        return this.getKeyByIDImp(domainID, 0);
    }

    public byte[] getActiveKey(int domainID) throws AppException {
        return this.getKeyByteByID(domainID, 0, false);
    }

    public String getEncodeKeyByID(int domainID, int keyID) throws AppException {
        return this.getKeyByIDImp(domainID, keyID);
    }

    public byte[] getKeyByID(int domainID, int keyID) throws AppException {
        return this.getKeyByteByID(domainID, keyID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyByIDImp(int domainID, int keyID) throws AppException {
        byte[] key = this.getKeyByteByID(domainID, keyID, true);
        String keyStr = null;
        try {
            if (key != null) {
                keyStr = new String(key, Constant.DEFAULT_CHARSET);
            }
        }
        finally {
            if (key != null) {
                Arrays.fill(key, (byte)0);
            }
        }
        return keyStr;
    }

    private byte[] getKeyByteByID(int domainID, int keyID, boolean encodeInd) throws AppException {
        int result;
        this.checkInit();
        byte[] key = null;
        JNIRefObj refKey = new JNIRefObj();
        int base64Ind = 0;
        if (encodeInd) {
            base64Ind = 1;
        }
        if ((result = this.keGetKeyByID(domainID, keyID, refKey, base64Ind)) != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("getKeyByID failed,result=" + result);
        }
        key = refKey.getByteArray();
        return key;
    }

    public byte[] hmac(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        if (plainText == null || plainText.length == 0) {
            throw new AppException("plainText cannot be null.");
        }
        JNIRefObj refHmacData = new JNIRefObj();
        int result = this.keHmacByDomain(domainID, plainText, refHmacData);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Hmac in domain " + domainID + " failed, result=" + result);
        }
        return refHmacData.getByteArray();
    }

    public boolean hmacVerify(int domainID, byte[] plainText, byte[] hmacData) throws AppException {
        this.checkInit();
        boolean isVerifySucess = false;
        if (plainText == null || plainText.length == 0) {
            throw new AppException("The plainText cannot be null.");
        }
        if (hmacData == null || hmacData.length == 0) {
            throw new AppException("The hmacData cannot be null.");
        }
        JNIRefObj refResult = new JNIRefObj();
        int result = this.keHmacVerifyByDomain(domainID, plainText, hmacData, refResult);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            if (refResult.getIntVal() == 1) {
                isVerifySucess = true;
            }
        } else {
            throw new AppException("HmacVerify in " + domainID + "  failed,result=" + result);
        }
        return isVerifySucess;
    }

    public void printAllInfoToLog() {
        this.kePrintAllInfoToLog();
    }

    public void checkAndUpdateMk(int domainID, int lifeTimeDays) throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            if (lifeTimeDays < 0 || lifeTimeDays > 180) {
                throw new AppException("lifeTimeDays should be [0 180]");
            }
            int ret = this.keCheckAndUpdateMk(domainID, 180 - lifeTimeDays);
            if (ret == Errno.KE_RET_SUCCESS.getCode()) {
                return;
            }
            throw new AppException("faild to active domain error code " + ret);
        }
    }

    public int getMaxMkID(int domainID) throws AppException {
        this.checkInit();
        int maxKeyID = 0;
        JNIRefObj refMaxKeyID = new JNIRefObj();
        int result = this.keGetMaxMkID(domainID, refMaxKeyID);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("getMaxMkID failed,result=" + result);
        }
        maxKeyID = refMaxKeyID.getIntVal();
        return maxKeyID;
    }

    public boolean isExistMkID(int domainID, int keyID) throws AppException {
        this.checkInit();
        boolean isExist = false;
        JNIRefObj refResult = new JNIRefObj();
        int result = this.keIsExistMkID(domainID, keyID, refResult);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            if (refResult.getIntVal() == 1) {
                isExist = true;
            }
        } else {
            throw new AppException("IsExistMkID failed,result=" + result);
        }
        return isExist;
    }

    public int getMkCount() throws AppException {
        this.checkInit();
        return this.keGetMkCount();
    }

    public KmcMkInfo getMkInfo(int idx) throws AppException {
        this.checkInit();
        return this.keGetMkInfo(idx);
    }

    public static synchronized void setJniNotifyCallback(INotifyCallback notifyCallback) {
        if (CryptoAPI.notifyCallback != null) {
            return;
        }
        CryptoAPI.notifyCallback = notifyCallback;
    }

    public static synchronized void setJniLogger(ILogger logger) {
        if (CryptoAPI.logger != null) {
            return;
        }
        CryptoAPI.logger = logger;
    }

    public static synchronized void setLogLevel(ILogger.LogLevel level) {
        if (level == null) {
            return;
        }
        CryptoAPI.keSetLogLevel(level.ordinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importMkFile(String fileName, byte[] pwdText) throws AppException {
        int result;
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            ILogger iLogger = CryptoAPI.getLogger();
            iLogger.info("CryptoAPI importMkFile");
            if (fileName == null || fileName.isEmpty()) {
                throw new AppException("fileName cannot be null");
            }
            if (pwdText == null || pwdText.length == 0) {
                throw new AppException("pwdText cannot be null");
            }
            byte[] fileNameBytes = fileName.getBytes(Constant.DEFAULT_CHARSET);
            int fileNameLen = fileNameBytes.length;
            byte[] concatFileName = new byte[fileNameLen + 1];
            Arrays.fill(concatFileName, (byte)0);
            System.arraycopy(fileNameBytes, 0, concatFileName, 0, fileNameLen);
            result = this.keImportMkFile(concatFileName, pwdText);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                iLogger.error("failed to importMkFile,result = " + result);
                throw new AppException("failed to importMkFile,result = " + result);
            }
        }
        return result;
    }

    public int exportMkFile(String fileName, byte[] pwdText) throws AppException {
        this.checkInit();
        ILogger iLogger = CryptoAPI.getLogger();
        iLogger.info("CryptoAPI exportMkFile");
        if (fileName == null || fileName.isEmpty()) {
            throw new AppException("fileName cannot be null.");
        }
        if (pwdText == null || pwdText.length == 0) {
            throw new AppException("pwdText cannot be null.");
        }
        byte[] fileNameBytes = fileName.getBytes(Constant.DEFAULT_CHARSET);
        int fileNameLen = fileNameBytes.length;
        byte[] concatFileName = new byte[fileNameLen + 1];
        Arrays.fill(concatFileName, (byte)0);
        System.arraycopy(fileNameBytes, 0, concatFileName, 0, fileNameLen);
        int result = this.keExportMkFile(concatFileName, pwdText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to exportMkFile,result = " + result);
            throw new AppException("failed to exportMkFile,result = " + result);
        }
        return result;
    }

    public int importKsf(KmcImportCfg importCfg) throws AppException {
        this.checkInit();
        ILogger iLogger = CryptoAPI.getLogger();
        iLogger.info("CryptoAPI import keystore file");
        if (!importCfg.isValidConfig()) {
            throw new AppException("import config is invalid.");
        }
        int result = this.keImportKsf(importCfg);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to import keystore file,result = " + result);
            throw new AppException("failed to import keystore file,result = " + result);
        }
        return result;
    }

    public int exportKsf(KmcExportCfg exportCfg) throws AppException {
        this.checkInit();
        ILogger iLogger = CryptoAPI.getLogger();
        iLogger.info("CryptoAPI export keystore file");
        if (!exportCfg.isValidConfig()) {
            throw new AppException("export config is invalid.");
        }
        int result = this.keExportKsf(exportCfg);
        iLogger.error("export keystore file,result = " + result);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to export keystore file,result = " + result);
            throw new AppException("failed to export keystore file,result = " + result);
        }
        return result;
    }

    public void removeKeyByKeyID(int domainID, int keyID) throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            logger.info("stage: " + (Object)((Object)stage) + "domainID: " + domainID);
            int ret = this.keRemoveKeyByID(domainID, keyID);
            if (ret == Errno.KE_RET_SUCCESS.getCode()) {
                return;
            }
            throw new AppException("failed to remove key, error code: " + ret);
        }
    }

    public synchronized void refreshMkMask() throws AppException {
        this.checkInit();
        int result = this.keRefreshMkMask();
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("refreshMkMask failed result=" + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRootKey() throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keUpdateRootKey();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("updateRootKey failed result=" + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void secureEraseKeystore() throws AppException {
        Object object = lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keSecEraseKeystore();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("secEraseKeystore failed result=" + result);
            }
        }
    }

    public String toString() {
        return "**not support toString**";
    }

    static {
        try {
            if (stage != InitStage.UNINIT) {
                throw new AppException("stage error " + stage.ordinal());
            }
            CryptoAPI.loadLibs();
            stage = InitStage.JNI_LOADED;
        }
        catch (AppException e) {
            int n = stage.ordinal();
        }
    }
}

