/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.Provider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import sun.security.provider.SunEntries;
import sun.security.util.SecurityConstants;

public abstract class SunJSSE
extends java.security.Provider {
    private static final long serialVersionUID = 3231825739635378733L;
    private static String info = "Sun JSSE provider(PKCS12, SunX509/PKIX key/trust factories, SSLv3/TLSv1/TLSv1.1/TLSv1.2/TLSv1.3)";
    private static String fipsInfo = "Sun JSSE provider (FIPS mode, crypto provider ";
    private static Boolean fips;
    static java.security.Provider cryptoProvider;

    protected static synchronized boolean isFIPS() {
        if (fips == null) {
            fips = false;
        }
        return fips;
    }

    private static synchronized void ensureFIPS(java.security.Provider provider) {
        if (fips == null) {
            fips = true;
            cryptoProvider = provider;
        } else {
            if (!fips.booleanValue()) {
                throw new ProviderException("SunJSSE already initialized in non-FIPS mode");
            }
            if (cryptoProvider != provider) {
                throw new ProviderException("SunJSSE already initialized with FIPS crypto provider " + cryptoProvider);
            }
        }
    }

    protected SunJSSE() {
        super("SunJSSE", 1.8, info);
        this.subclassCheck();
        if (Boolean.TRUE.equals(fips)) {
            throw new ProviderException("SunJSSE is already initialized in FIPS mode");
        }
        this.registerAlgorithms(false);
    }

    protected SunJSSE(java.security.Provider provider) {
        this(SunJSSE.checkNull(provider), provider.getName());
    }

    protected SunJSSE(String string) {
        this(null, SunJSSE.checkNull(string));
    }

    private static <T> T checkNull(T t) {
        if (t == null) {
            throw new ProviderException("cryptoProvider must not be null");
        }
        return t;
    }

    private SunJSSE(java.security.Provider provider, String string) {
        super("SunJSSE", (Double)((Object)SecurityConstants.PROVIDER_VER), fipsInfo + string + ")");
        this.subclassCheck();
        if (provider == null && (provider = Security.getProvider(string)) == null) {
            throw new ProviderException("Crypto provider not installed: " + string);
        }
        SunJSSE.ensureFIPS(provider);
        this.registerAlgorithms(true);
    }

    private void registerAlgorithms(final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SunJSSE.this.doRegister(bl);
                return null;
            }
        });
    }

    private void ps(String string, String string2, String string3, List<String> list, HashMap<String, String> hashMap) {
        this.putService(new Provider.Service(this, string, string2, string3, list, hashMap));
    }

    private void doRegister(boolean bl) {
        if (!bl) {
            String string = "1.2.840.113549.1.1";
            List list = SunEntries.createAliasesWithOid((String[])new String[]{string});
            String string2 = "1.3.14.3.2.29";
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            hashMap.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
            this.ps("KeyFactory", "RSA", "sun.security.rsa.RSAKeyFactory$Legacy", list, null);
            this.ps("KeyPairGenerator", "RSA", "sun.security.rsa.RSAKeyPairGenerator$Legacy", list, null);
            this.ps("Signature", "MD2withRSA", "sun.security.rsa.RSASignature$MD2withRSA", SunEntries.createAliasesWithOid((String[])new String[]{string + ".2"}), hashMap);
            this.ps("Signature", "MD5withRSA", "sun.security.rsa.RSASignature$MD5withRSA", SunEntries.createAliasesWithOid((String[])new String[]{string + ".4"}), hashMap);
            this.ps("Signature", "SHA1withRSA", "sun.security.rsa.RSASignature$SHA1withRSA", SunEntries.createAliasesWithOid((String[])new String[]{string + ".5", string2, "OID." + string2}), hashMap);
        }
        this.ps("Signature", "MD5andSHA1withRSA", "sun.security.ssl.RSASignature", null, null);
        this.ps("KeyManagerFactory", "SunX509", "sun.security.ssl.KeyManagerFactoryImpl$SunX509", null, null);
        this.ps("KeyManagerFactory", "NewSunX509", "sun.security.ssl.KeyManagerFactoryImpl$X509", SunEntries.createAliases((String[])new String[]{"PKIX"}), null);
        this.ps("TrustManagerFactory", "SunX509", "sun.security.ssl.TrustManagerFactoryImpl$SimpleFactory", null, null);
        this.ps("TrustManagerFactory", "PKIX", "sun.security.ssl.TrustManagerFactoryImpl$PKIXFactory", SunEntries.createAliases((String[])new String[]{"SunPKIX", "X509", "X.509"}), null);
        this.ps("SSLContext", "TLSv1", "sun.security.ssl.SSLContextImpl$TLS10Context", bl ? null : SunEntries.createAliases((String[])new String[]{"SSLv3"}), null);
        this.ps("SSLContext", "TLSv1.1", "sun.security.ssl.SSLContextImpl$TLS11Context", null, null);
        this.ps("SSLContext", "TLSv1.2", "sun.security.ssl.SSLContextImpl$TLS12Context", null, null);
        this.ps("SSLContext", "TLSv1.3", "sun.security.ssl.SSLContextImpl$TLS13Context", null, null);
        this.ps("SSLContext", "TLS", "sun.security.ssl.SSLContextImpl$TLSContext", bl ? null : SunEntries.createAliases((String[])new String[]{"SSL"}), null);
        this.ps("SSLContext", "Default", "sun.security.ssl.SSLContextImpl$DefaultSSLContext", null, null);
        this.ps("KeyStore", "PKCS12", "sun.security.pkcs12.PKCS12KeyStore", null, null);
    }

    private void subclassCheck() {
        if (this.getClass() != Provider.class) {
            throw new AssertionError((Object)("Illegal subclass: " + this.getClass()));
        }
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }
}

