/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrade.service.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrade.service.UpgradeFileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeFileServiceHandler
implements UpgradeFileService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeFileServiceHandler.class);

    private UpgradeFileServiceHandler() {
    }

    public static UpgradeFileServiceHandler getInstance() {
        return UpgradeFileServiceHandlerHolder.INSTANCE;
    }

    @Override
    public JSONObject getJsonData(String jsonPath) {
        JSONObject jsonData = null;
        String jsonString = IcsFileUtils.readFileContent((String)(IcsCommonServiceHandler.getInstance().getAppRootDir() + jsonPath), null);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The JSON file is empty.");
            return jsonData;
        }
        try {
            jsonData = JSONObject.parseObject((String)jsonString);
        }
        catch (JSONException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "failed to cast to JSONObject.", (Throwable)ex);
        }
        return jsonData;
    }

    @Override
    public String downloadUpgradeFile(String serverFileUrl, HttpClientDto httpClientDto) {
        boolean isDownload;
        String upgradeJsonPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.SERVER_UPGRADE_PATH;
        File file = FileUtils.getFile((String[])new String[]{upgradeJsonPath});
        if (file.exists() && !file.delete()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "delete file error,file name is {0}", new Object[]{file.getName()});
        }
        if (isDownload = this.downloadFile(httpClientDto, serverFileUrl, IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade", "upgradeJson.json")) {
            return "20";
        }
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to download the server file.");
        return "40";
    }

    @Override
    public String downloadLiteUpgraderFile(HttpClientDto httpClientDto, String liteUpgraderUrl) {
        boolean isDownload = this.downloadFile(httpClientDto, liteUpgraderUrl, IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade", "liteUpgraderBak.json");
        if (isDownload) {
            return "20";
        }
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to download the ICS Lite upgrader information file,the url is {0}.", new Object[]{liteUpgraderUrl});
        return "40";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean downloadFile(HttpClientDto httpClientDto, String downloadUrl, String fileDir, String fileName) {
        if (StringUtils.isBlank((CharSequence)downloadUrl)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The software upgrade and download association is empty.");
            return false;
        }
        HttpClientDto build = httpClientDto.newBuilder().url(downloadUrl).build();
        try (InputStream inputStream = NetWorkUtil.getInputStream((HttpClientDto)build);){
            if (inputStream == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get InputStream is null.");
                boolean bl = false;
                return bl;
            }
            boolean isSuccess = NetWorkUtil.writeFile((String)fileDir, (String)fileName, (InputStream)inputStream);
            if (isSuccess) return true;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Write file error");
            boolean bl = false;
            return bl;
        }
        catch (DownloadException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get InputStream error.", e);
            return false;
        }
    }

    public String getServerVersion() {
        JSONObject clientUpgradeJson = this.getJsonData(CommonConstants.SERVER_UPGRADE_PATH);
        if (MapUtils.isEmpty((Map)clientUpgradeJson)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Low version and the server software information is empty.");
            return "";
        }
        return clientUpgradeJson.getString("clientVersion");
    }

    @Override
    public Map<String, Object> icsliteIsChanged(String lowVersionStr) {
        String appVersion = IcsCommonServiceHandler.getInstance().getAppVersion();
        JSONObject clientUpgradeJson = this.getJsonData(CommonConstants.SERVER_UPGRADE_PATH);
        if (MapUtils.isEmpty((Map)clientUpgradeJson)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The server software information is empty.");
            return MapUtils.emptyIfNull(null);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String serverVersion = clientUpgradeJson.getString("clientVersion");
        resultMap.put("appVersion", appVersion);
        resultMap.put("seedVersion", serverVersion);
        if (StringUtils.isBlank((CharSequence)serverVersion)) {
            resultMap.put("isChanged", false);
            return resultMap;
        }
        if (StringUtils.isBlank((CharSequence)appVersion) || StringUtils.isBlank((CharSequence)serverVersion)) {
            return resultMap;
        }
        if (!StringUtils.equals((CharSequence)appVersion, (CharSequence)serverVersion)) {
            resultMap.put("isChanged", true);
            if (StringUtils.isBlank((CharSequence)lowVersionStr)) {
                return resultMap;
            }
            Arrays.stream(lowVersionStr.split(",")).forEach(version -> {
                if (StringUtils.equals((CharSequence)appVersion, (CharSequence)version)) {
                    resultMap.put("isLowVersion", true);
                }
            });
        } else {
            resultMap.put("isChanged", false);
        }
        return resultMap;
    }

    private static class UpgradeFileServiceHandlerHolder {
        private static final UpgradeFileServiceHandler INSTANCE = new UpgradeFileServiceHandler();

        private UpgradeFileServiceHandlerHolder() {
        }
    }
}

