/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrade.constant.UpgradeAtomConstants;
import com.huawei.support.icslite.upgrade.dto.UpgradeInfoDto;
import com.huawei.support.icslite.upgrade.service.UpgradeService;
import com.huawei.support.icslite.upgrade.service.impl.UpgradeFileServiceHandler;
import com.huawei.support.icslite.upgrade.util.FileResourceUtils;
import com.huawei.support.icslite.upgrade.util.GetFileSha256;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeServiceHandler
implements UpgradeService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeServiceHandler.class);
    private static final String DOWNLOADED_ZIP_FILE_FAILED = "delete downloaded zip file failed.";
    private static final String UPGRADE_DIRECTORY = File.separator + "upgrade" + File.separator;
    private static final long MAX_FILE_COUNT = 99L;

    private UpgradeServiceHandler() {
    }

    public static UpgradeServiceHandler getInstance() {
        return UpgradeServiceHandlerHolder.INSTANCE;
    }

    private static String getFirstPathDirectory(String path) {
        long fileCount = 0L;
        File file = FileUtils.getFile((String[])new String[]{path});
        if (!file.exists()) {
            return "";
        }
        String firstPathDirectory = "";
        try (FileInputStream fileInputStream = FileUtils.openInputStream((File)file);
             ZipInputStream zipInputStream = new ZipInputStream((InputStream)fileInputStream, Charset.forName("GBK"));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.isDirectory()) {
                    firstPathDirectory = zipEntry.getName().replace("/", "");
                    break;
                }
                if (++fileCount > 99L) {
                    throw new IOException("The ZIP package contains too many files.");
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "The zip file read error", (Throwable)e);
        }
        return firstPathDirectory;
    }

    @Override
    public UpgradeInfoDto checkUpgradeInfo(HttpClientDto httpClient, String serverFileUrl, String lowVersionStr) {
        JSONObject clientUpgradeJson;
        Object serverVersion;
        Map<String, Object> icsliteMap;
        File upgradeFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "upgradeOperate.txt"});
        UpgradeInfoDto upgradeInfoDto = new UpgradeInfoDto();
        if (upgradeFile == null) {
            upgradeInfoDto.setUpgrade(false);
        } else {
            upgradeInfoDto.setUpgrade(upgradeFile.exists());
        }
        String checkState = UpgradeFileServiceHandler.getInstance().downloadUpgradeFile(serverFileUrl, httpClient);
        upgradeInfoDto.setCheckError("0");
        if ("40".equals(checkState)) {
            upgradeInfoDto.setCheckError("1");
        }
        if (MapUtils.isEmpty(icsliteMap = UpgradeFileServiceHandler.getInstance().icsliteIsChanged(lowVersionStr))) {
            upgradeInfoDto.setCheckError("1");
        }
        if ((serverVersion = icsliteMap.get("seedVersion")) == null) {
            upgradeInfoDto.setCheckError("1");
        }
        Object changed = icsliteMap.get("isChanged");
        boolean isChanged = Boolean.FALSE;
        if (changed instanceof Boolean) {
            isChanged = (Boolean)changed;
        }
        upgradeInfoDto.setChanged(isChanged);
        if (!isChanged) {
            return upgradeInfoDto;
        }
        Object lowVersionFlag = icsliteMap.get("isLowVersion");
        if (ObjectUtils.isNotEmpty((Object)lowVersionFlag) && lowVersionFlag instanceof Boolean) {
            upgradeInfoDto.setLowVersion((Boolean)lowVersionFlag);
            CodeCCUtils.INSTANCE.infoLog(LOG, "Check upgrade info and current version is low version.");
        }
        if (MapUtils.isNotEmpty((Map)(clientUpgradeJson = UpgradeFileServiceHandler.getInstance().getJsonData(CommonConstants.SERVER_UPGRADE_PATH)))) {
            String softVersion = clientUpgradeJson.getString("clientVersion");
            upgradeInfoDto.setNextVersion(softVersion);
            String releaseNote = clientUpgradeJson.getString("clientReleaseNotesHtml");
            upgradeInfoDto.setReleaseNote(releaseNote);
            String autoUpgrade = clientUpgradeJson.getString("autoUpgrade");
            upgradeInfoDto.setAutoUpgrade(StringUtils.isBlank((CharSequence)autoUpgrade) || StringUtils.equals((CharSequence)autoUpgrade, (CharSequence)"1"));
        }
        return upgradeInfoDto;
    }

    public void deleteUpgradeFile(String upgradeFilePath) {
        try {
            IcsFileUtils.deleteFile((File)FileUtils.getFile((String[])new String[]{upgradeFilePath}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "excute delete UpgradeFile exception.", (Throwable)e);
        }
        try {
            IcsFileUtils.deleteFile((File)FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.APP_UPGRADE_TEMP_DIR}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "excute delete temp dir exception.", (Throwable)e);
        }
        try {
            IcsFileUtils.deleteFile((File)FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getUpgraderJavaHomeDir()}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "excute delete upgrader jre dir exception.", (Throwable)e);
        }
    }

    public String upgraderUpdateOperation(HttpClientDto httpClient, String downloadDomainUrl, String liteUpgraderUrl) {
        String downLoadState = UpgradeFileServiceHandler.getInstance().downloadLiteUpgraderFile(httpClient, liteUpgraderUrl);
        if (StringUtils.equals((CharSequence)"40", (CharSequence)downLoadState)) {
            File file = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.SERVER_UPGRADE_PATH});
            boolean isDelete = file.delete();
            if (!isDelete) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Delete lite upgrader information file error,file name is {0}", new Object[]{file.getName()});
            }
            return downLoadState;
        }
        boolean isChanged = this.checkUpgraderVersion();
        if (!isChanged) {
            File serverUpgraderInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgraderBak.json"});
            boolean isDel = serverUpgraderInfoFile.delete();
            CodeCCUtils.INSTANCE.infoLog(LOG, "delete LiteUpgraderBak.txt file status:{0}", new Object[]{isDel});
            return "20";
        }
        downLoadState = this.upgraderUpdateProcess(httpClient, downloadDomainUrl);
        if ("40".equals(downLoadState)) {
            File serverUpgraderInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgraderBak.json"});
            boolean isDel = serverUpgraderInfoFile.delete();
            CodeCCUtils.INSTANCE.errorLog(LOG, "upgrade download failed, delete LiteUpgraderBak.txt file status:{0}", new Object[]{isDel});
        }
        return downLoadState;
    }

    @Override
    public void openUpgrader() {
        IcsCommonServiceHandler.getInstance().startUpgrader();
    }

    public String unZipProcess(String filePath, String zipFileName) {
        String firstPathDirectory;
        File tempDir = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.APP_UPGRADE_TEMP_DIR});
        try {
            IcsFileUtils.deleteFile((File)tempDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Unzip process and delete temp directory failed.", (Throwable)e);
        }
        String zipFilePath = filePath + File.separator + zipFileName;
        File zipFile = FileUtils.getFile((String[])new String[]{zipFilePath});
        if (!zipFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Unzip process and the software package to be decompressed does not exist.");
            return "40";
        }
        boolean isUnZipSuccess = ZipFileUtils.unZip((String)zipFilePath, (String)(IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.APP_UPGRADE_TEMP_DIR));
        String unZipFlag = "20";
        if (!isUnZipSuccess) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Unzip process and unzip failed.");
            try {
                IcsFileUtils.deleteFile((File)tempDir);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete temp directory failed.", (Throwable)e);
            }
            File softVersionDir = FileUtils.getFile((String[])new String[]{filePath});
            try {
                IcsFileUtils.deleteFile((File)softVersionDir);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, DOWNLOADED_ZIP_FILE_FAILED, (Throwable)e);
            }
            unZipFlag = "40";
        }
        if (!this.reNameUnZipFileFirstDirectory(firstPathDirectory = UpgradeServiceHandler.getFirstPathDirectory(zipFilePath))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to rename the decompression directory {0}.", new Object[]{firstPathDirectory});
            unZipFlag = "40";
        }
        return unZipFlag;
    }

    private boolean reNameUnZipFileFirstDirectory(String firstPathDirectory) {
        File tempUnZipFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.APP_UPGRADE_TEMP_DIR + File.separator + firstPathDirectory});
        File tempIcsLiteFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.APP_UPGRADE_TEMP_DIR + File.separator + "ICSLite"});
        if (tempUnZipFile.renameTo(tempIcsLiteFile)) {
            return true;
        }
        boolean isSuccess = true;
        try {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ReNameUnZipFileFirstDirectory renaming failed. The folder will be copied.");
            FileUtils.copyDirectory((File)tempUnZipFile, (File)tempIcsLiteFile);
            if (!FileUtils.deleteQuietly((File)tempUnZipFile)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to silently delete the upgrade resource folder.");
            }
        }
        catch (IOException e) {
            isSuccess = false;
            CodeCCUtils.INSTANCE.errorLog(LOG, "Fail to copy file. ", (Throwable)e);
        }
        return isSuccess;
    }

    public boolean isFreeSpace() {
        long freeDiskSpace = FileResourceUtils.getFreeDisk(IcsCommonServiceHandler.getInstance().getAppRootDir());
        long remainSpace = 1250L;
        CodeCCUtils.INSTANCE.debugLog(LOG, "RemainSpace:" + remainSpace);
        CodeCCUtils.INSTANCE.debugLog(LOG, "FreeDiskSpace:" + freeDiskSpace);
        return freeDiskSpace >= remainSpace;
    }

    private boolean checkUpgraderVersion() {
        File oldUpgraderInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgrader.json"});
        if (!oldUpgraderInfoFile.exists()) {
            return true;
        }
        String serverUpgradereVersion = this.getUpgraderVersion(UPGRADE_DIRECTORY + "liteUpgraderBak.json");
        if (StringUtils.isBlank((CharSequence)serverUpgradereVersion)) {
            File file = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgraderBak.json"});
            try {
                IcsFileUtils.deleteFile((File)file);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "Server upgradr information file delete failed", (Throwable)e);
            }
            return false;
        }
        String appUpgraderVersion = this.getUpgraderVersion(UPGRADE_DIRECTORY + "liteUpgrader.json");
        return !StringUtils.equals((CharSequence)appUpgraderVersion, (CharSequence)serverUpgradereVersion);
    }

    private String getUpgraderVersion(String path) {
        String upgraderVersion = "";
        JSONObject liteUpgraderData = UpgradeFileServiceHandler.getInstance().getJsonData(path);
        if (MapUtils.isNotEmpty((Map)liteUpgraderData)) {
            upgraderVersion = liteUpgraderData.getString("upgraderVersion");
        }
        return upgraderVersion;
    }

    private String upgraderUpdateProcess(HttpClientDto httpClientDto, String downloadDomainUrl) {
        File oldUpgraderInfoFile;
        String upgradeZipPath = IcsCommonServiceHandler.getInstance().getAppBinDir() + File.separator + "icsLiteUpgrade.zip";
        File newJarFile = FileUtils.getFile((String[])new String[]{upgradeZipPath});
        File newUpgraderInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgraderBak.json"});
        String jarDownLoadState = this.upgraderDownloadProcess(httpClientDto, downloadDomainUrl);
        if ("40".equals(jarDownLoadState)) {
            boolean isDeleteJarFile = newJarFile.delete();
            boolean isDeleteInfoFile = newUpgraderInfoFile.delete();
            if (!isDeleteJarFile) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete new jar file failed.");
            }
            if (!isDeleteInfoFile) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete new upgrader info file failed.");
            }
            CodeCCUtils.INSTANCE.infoLog(LOG, "The upgrader file downLoad failed.");
            return jarDownLoadState;
        }
        String oldJarPath = IcsCommonServiceHandler.getInstance().getAppBinDir() + File.separator + "icsLiteUpgrade.jar";
        File oldJarFile = FileUtils.getFile((String[])new String[]{oldJarPath});
        if (!oldJarFile.delete()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "local upgrader jar file delete failed");
            jarDownLoadState = "40";
        }
        if (!newJarFile.renameTo(oldJarFile)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "server upgrader zip fie rename to local file failed");
            try {
                IcsFileUtils.copyFile((String)upgradeZipPath, (String)oldJarPath);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "server upgrader zip fie copy to local file failed");
                jarDownLoadState = "40";
                return jarDownLoadState;
            }
        }
        if (!(oldUpgraderInfoFile = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + UPGRADE_DIRECTORY + "liteUpgrader.json"})).delete()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "local upgrader info file delete failed");
            jarDownLoadState = "40";
        }
        if (!newUpgraderInfoFile.renameTo(oldUpgraderInfoFile)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "server upgrader info fie rename to local file failed");
            jarDownLoadState = "40";
        }
        return jarDownLoadState;
    }

    private String upgraderDownloadProcess(HttpClientDto httpClientDto, String downloadDomainUrl) {
        JSONObject liteUpgraderBakData = UpgradeFileServiceHandler.getInstance().getJsonData(UPGRADE_DIRECTORY + "liteUpgraderBak.json");
        String upgraderDownLoadUrl = null;
        String upgraderIntegrityCode = null;
        if (MapUtils.isNotEmpty((Map)liteUpgraderBakData)) {
            upgraderDownLoadUrl = downloadDomainUrl + liteUpgraderBakData.getString("upgraderDownLoadUrl.v2");
            upgraderIntegrityCode = liteUpgraderBakData.getString("upgraderIntegrityCode");
        }
        String filePath = IcsCommonServiceHandler.getInstance().getAppBinDir();
        String downloadState = "40";
        boolean isDownload = UpgradeFileServiceHandler.getInstance().downloadFile(httpClientDto, upgraderDownLoadUrl, filePath, "icsLiteUpgrade.zip");
        if (!isDownload) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Download upgrader fail when upgrader download process,the upgrader download url is {0}.", new Object[]{upgraderDownLoadUrl});
            return downloadState;
        }
        String downLoadJarPath = filePath + File.separator + "icsLiteUpgrade.zip";
        downloadState = GetFileSha256.checkSha256Code(upgraderIntegrityCode, downLoadJarPath);
        if (StringUtils.equals((CharSequence)downloadState, (CharSequence)"40")) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Check upgrader sha 256 code fail.");
        }
        return downloadState;
    }

    private static class UpgradeServiceHandlerHolder {
        private static final UpgradeServiceHandler INSTANCE = new UpgradeServiceHandler();

        private UpgradeServiceHandlerHolder() {
        }
    }
}

