/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrade.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileResourceUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(FileResourceUtils.class);
    private static final int BYTE_UNIT = 1024;
    private static final Pattern DISK_PATTERN = Pattern.compile("[a-zA-Z](?=:\\\\)");

    private FileResourceUtils() {
    }

    public static long getFreeDisk(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "getFreeDisk filePath is blank");
            return 0L;
        }
        File file = FileUtils.getFile((String[])new String[]{filePath});
        if (!file.exists()) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "getFreeDisk file is not exist : {0}", new Object[]{filePath});
            return 0L;
        }
        return file.getFreeSpace() / 0x100000L;
    }

    public static String getDiskName(String filePath) {
        Matcher matcher = DISK_PATTERN.matcher(filePath);
        if (matcher.find()) {
            return matcher.group().toUpperCase(Locale.ROOT);
        }
        return "";
    }
}

