/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrade.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GetFileSha256 {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(GetFileSha256.class);
    private static final int BYTE = 1024;

    private GetFileSha256() {
    }

    public static String checkSha256Code(String softwarePackageShaCode, String downloadsPath) {
        String downloadsPathSha;
        File downloadsPathFile = FileUtils.getFile((String[])new String[]{downloadsPath});
        if (downloadsPathFile.exists() && downloadsPathFile.length() > 0L && StringUtils.equalsIgnoreCase((CharSequence)softwarePackageShaCode, (CharSequence)(downloadsPathSha = GetFileSha256.getFileSha(downloadsPathFile)))) {
            return "20";
        }
        CodeCCUtils.INSTANCE.errorLog(LOG, "Check sha 256 code fail,the file path is {0}.", new Object[]{downloadsPath});
        return "40";
    }

    private static String getFileSha(File file) {
        return GetFileSha256.getHash(file, "SHA-256");
    }

    private static String getHash(File file, String shaType) {
        String result = null;
        try (BufferedInputStream fis = new BufferedInputStream(FileUtils.openInputStream((File)file));){
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance(shaType);
            int numRead = fis.read(buffer);
            while (numRead > 0) {
                md.update(buffer, 0, numRead);
                numRead = fis.read(buffer);
            }
            result = new HexBinaryAdapter().marshal(md.digest());
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "SHA-256 IO error.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "SHA-256 error.", (Throwable)e);
        }
        if (StringUtils.isBlank(result)) {
            return "";
        }
        return result.toLowerCase(Locale.ENGLISH);
    }
}

