/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.favorites.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.favorites.dto.FavoritesDo;
import com.huawei.support.icslite.favorites.mapper.FavoritesMapper;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public class FavoritesDaoHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(FavoritesDaoHandler.class);
    private static final FavoritesMapper FAVORITES_MAPPER = (FavoritesMapper)DbMapperUtils.getMapper(FavoritesMapper.class);

    private FavoritesDaoHandler() {
    }

    public static FavoritesDaoHandler getInstance() {
        return FavoritesDaoHandlerHolder.INSTANCE;
    }

    public void createTb() {
        try {
            FAVORITES_MAPPER.createTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(log, "Table 'FAVORITE' already exists or create error.", e);
        }
    }

    public boolean add(FavoritesDo favoritesDo) {
        return FAVORITES_MAPPER.add(favoritesDo);
    }

    public boolean delFavorites(FavoritesDo favoritesDo) {
        return FAVORITES_MAPPER.delFavorites(favoritesDo);
    }

    public int delFavoritesList(List<String> favoritesIds) {
        return FAVORITES_MAPPER.delFavoritesList(favoritesIds);
    }

    public List<String> getProdNameList() {
        return FAVORITES_MAPPER.getProdNameList();
    }

    public List<FavoritesDo> findFavoritesByLibAttr(FavoritesDo favoritesDo) {
        return FAVORITES_MAPPER.getFavoritesByLibAttr(favoritesDo);
    }

    public int updateLatestFavorite(FavoritesDo favoritesDo) {
        return FAVORITES_MAPPER.updateLatestFavorite(favoritesDo);
    }

    public int getFavoritesTotalCount() {
        return FAVORITES_MAPPER.getFavoritesTotalCount();
    }

    public List<FavoritesDo> getAllFavorites() {
        return FAVORITES_MAPPER.getAllFavorites();
    }

    public List<FavoritesDo> getFavoritesByProdName(String productName) {
        return FAVORITES_MAPPER.getFavoritesByProdName(productName);
    }

    private static class FavoritesDaoHandlerHolder {
        private static final FavoritesDaoHandler INSTANCE = new FavoritesDaoHandler();

        private FavoritesDaoHandlerHolder() {
        }
    }
}

