/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.favorites.service.impl;

import com.huawei.support.icslite.favorites.dao.FavoritesDaoHandler;
import com.huawei.support.icslite.favorites.dto.FavoritesDo;
import com.huawei.support.icslite.favorites.service.FavoritesService;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class FavoritesServiceHandler
implements FavoritesService {
    private FavoritesServiceHandler() {
    }

    public static FavoritesServiceHandler getInstance() {
        return FavoritesServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        FavoritesDaoHandler.getInstance().createTb();
    }

    @Override
    public boolean add(FavoritesDo favoritesDo) {
        return FavoritesDaoHandler.getInstance().add(favoritesDo);
    }

    @Override
    public boolean delFavorites(FavoritesDo favoritesDo) {
        return FavoritesDaoHandler.getInstance().delFavorites(favoritesDo);
    }

    @Override
    public int delFavoritesList(List<String> favoritesIds) {
        return FavoritesDaoHandler.getInstance().delFavoritesList(favoritesIds);
    }

    @Override
    public List<String> getProdNameList() {
        return FavoritesDaoHandler.getInstance().getProdNameList();
    }

    @Override
    public boolean hasFavoriteLibs(FavoritesDo favoritesDo) {
        List<FavoritesDo> favoriteList = FavoritesDaoHandler.getInstance().findFavoritesByLibAttr(favoritesDo);
        return CollectionUtils.isNotEmpty(favoriteList);
    }

    @Override
    public int getFavoritesTotalCount() {
        return FavoritesDaoHandler.getInstance().getFavoritesTotalCount();
    }

    @Override
    public List<FavoritesDo> getAllFavorites() {
        return FavoritesDaoHandler.getInstance().getAllFavorites();
    }

    @Override
    public List<FavoritesDo> getFavoritesByProdName(String productName) {
        return FavoritesDaoHandler.getInstance().getFavoritesByProdName(productName);
    }

    @Override
    public int updateLatestFavorite(FavoritesDo favoritesDo) {
        return FavoritesDaoHandler.getInstance().updateLatestFavorite(favoritesDo);
    }

    private static class FavoritesServiceHandlerHolder {
        private static final FavoritesServiceHandler INSTANCE = new FavoritesServiceHandler();

        private FavoritesServiceHandlerHolder() {
        }
    }
}

