/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.download.dao;

import com.alibaba.excel.util.StringUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.download.dto.TaskDo;
import com.huawei.support.icslite.download.mapper.DownloadMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public enum DownloadDaoHandler {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final String CATEGORY = "category";
    private static final String START_POINT = "startPoint";
    private static final String PAGE_SIZE = "pageSize";
    private static final int SIZE = 10;
    DownloadMapper downloadMapper = (DownloadMapper)DbMapperUtils.getMapper(DownloadMapper.class);

    public void createDownloadTb() {
        try {
            this.downloadMapper.createTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException var2) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "createTb ERROR", var2);
        }
    }

    public boolean addTasks(List<TaskDo> taskDos) {
        int index = 1;
        if (CollectionUtils.isEmpty(taskDos)) {
            return false;
        }
        int listSize = taskDos.size();
        try {
            List<TaskDo> tempList;
            while (listSize > index * 10) {
                tempList = taskDos.subList((index - 1) * 10, index * 10);
                this.downloadMapper.addTasks(tempList);
                ++index;
            }
            tempList = taskDos.subList((index - 1) * 10, listSize);
            if (CollectionUtils.isNotEmpty(tempList)) {
                this.downloadMapper.addTasks(tempList);
            }
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Add Download Tasks Error.", e);
            return false;
        }
        return true;
    }

    public int getCompletedListCount(String startTime, String endTime) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(CATEGORY, "2");
        this.setQueryTime(startTime, endTime, queryMap);
        return this.downloadMapper.getTaskCount(queryMap);
    }

    public int getTrashBoxListCount() {
        return this.downloadMapper.getTaskCount(Collections.singletonMap(CATEGORY, "3"));
    }

    public List<TaskDo> getCompletedList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATEGORY, "2");
        return this.downloadMapper.getListByCondition(map);
    }

    public List<TaskDo> getCompletedList(int pageNo, int pageSize, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATEGORY, "2");
        if (pageNo != -1 && pageSize != -1) {
            map.put(START_POINT, (pageNo - 1) * pageSize);
            map.put(PAGE_SIZE, pageSize);
        }
        this.setQueryTime(startTime, endTime, map);
        return this.downloadMapper.getListByCondition(map);
    }

    private void setQueryTime(String startTime, String endTime, Map<String, Object> map) {
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            map.put("startTime", Long.parseLong(startTime));
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            map.put("endTime", Long.parseLong(endTime));
        }
    }

    public List<TaskDo> getTrashBoxList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATEGORY, "3");
        return this.downloadMapper.getListByCondition(map);
    }

    public List<TaskDo> getTrashBoxList(int pageNo, int pageSize) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATEGORY, "3");
        map.put(START_POINT, (pageNo - 1) * pageSize);
        map.put(PAGE_SIZE, pageSize);
        return this.downloadMapper.getListByCondition(map);
    }

    public List<TaskDo> queryAllTask() {
        return this.downloadMapper.getListByCondition(new HashMap<String, Object>());
    }

    public void updateTaskAndRecordOperate(TaskDo taskDo) {
        taskDo.setOperateTime(System.currentTimeMillis());
        this.downloadMapper.updateTask(taskDo);
    }

    public void updateTask(TaskDo taskDo) {
        this.downloadMapper.updateTask(taskDo);
    }

    public TaskDo queryTask(String taskId) {
        return this.downloadMapper.queryTask(taskId);
    }

    public void deleteTask(String taskId) {
        this.downloadMapper.deleteTask(taskId);
    }

    public void deleteAllTrashTask() {
        this.downloadMapper.deleteAllTrashTask();
    }

    public void deleteAll() {
        this.downloadMapper.deleteAll();
    }

    static {
        LOG = CommonLoggerFactory.getLogger(DownloadDaoHandler.class);
    }
}

