/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.download.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.download.dto.SoftwareManageFileDo;
import com.huawei.support.icslite.download.mapper.SoftwareManageFileMapper;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public enum SoftwareManageFileDaoHandler {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final SoftwareManageFileMapper SOFTWARE_MANAGE_FILE_MAPPER;

    public void createTb() {
        try {
            SOFTWARE_MANAGE_FILE_MAPPER.createTb();
            SOFTWARE_MANAGE_FILE_MAPPER.createIdx();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'TB_SOFTWARE_MANAGE_FILE' already exists or create error.", e);
        }
    }

    public boolean addFiles(SoftwareManageFileDo fileDo) {
        return SOFTWARE_MANAGE_FILE_MAPPER.insertOrUpdateFiles(fileDo) > 0;
    }

    public boolean updateFile(SoftwareManageFileDo fileDo) {
        return SOFTWARE_MANAGE_FILE_MAPPER.updateFile(fileDo) > 0;
    }

    public boolean delFilesByDirIdAndStatus(int dirId, int status) {
        return SOFTWARE_MANAGE_FILE_MAPPER.delFilesByDirIdAndStatus(dirId, status) > 0;
    }

    public boolean delFilesByIds(List<Integer> fileIds) {
        return SOFTWARE_MANAGE_FILE_MAPPER.delFilesByIds(fileIds) > 0;
    }

    public boolean delFilesByDirId(int dirId) {
        return SOFTWARE_MANAGE_FILE_MAPPER.delFilesByDirId(dirId) > 0;
    }

    public List<SoftwareManageFileDo> getFilesByDirId(int dirId) {
        return SOFTWARE_MANAGE_FILE_MAPPER.getFilesByDirId(dirId);
    }

    public List<SoftwareManageFileDo> getFilesByIds(List<Integer> fileIds) {
        return SOFTWARE_MANAGE_FILE_MAPPER.getFilesByIds(fileIds);
    }

    public SoftwareManageFileDo getFileById(int fileId) {
        return SOFTWARE_MANAGE_FILE_MAPPER.getFileById(fileId);
    }

    static {
        LOG = CommonLoggerFactory.getLogger(SoftwareManageFileDaoHandler.class);
        SOFTWARE_MANAGE_FILE_MAPPER = (SoftwareManageFileMapper)DbMapperUtils.getMapper(SoftwareManageFileMapper.class);
    }
}

