/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.docnote.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryHdxNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryHomeNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryIcsNoteDo;
import com.huawei.support.icslite.docnote.mapper.DocNoteMapper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class DocNoteDaoHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocNoteDaoHandler.class);
    private static final DocNoteMapper DOC_NOTE_MAPPER = (DocNoteMapper)DbMapperUtils.getMapper(DocNoteMapper.class);

    private DocNoteDaoHandler() {
    }

    public static DocNoteDaoHandler getInstance() {
        return DocNoteDaoHandlerHolder.INSTANCE;
    }

    public void createTb() {
        try {
            DOC_NOTE_MAPPER.createTb();
            DOC_NOTE_MAPPER.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(log, "Table 'DOCNOTE' already exists or create error.", e);
        }
    }

    public int add(DocNoteDo docNoteDo) {
        try {
            return DOC_NOTE_MAPPER.add(docNoteDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.add Error", e);
            return 0;
        }
    }

    public List<DocNoteDo> getIcsTopicNote(QueryIcsNoteDo queryIcsNoteDo) {
        try {
            return DOC_NOTE_MAPPER.getIcsTopicNote(queryIcsNoteDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.getIcsTopicNote Error", e);
            return Collections.emptyList();
        }
    }

    public List<DocNoteDo> getHdxTopicNote(QueryHdxNoteDo queryHdxNoteDo) {
        try {
            return DOC_NOTE_MAPPER.getHdxTopicNote(queryHdxNoteDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.getHdxTopicNote Error", e);
            return Collections.emptyList();
        }
    }

    public List<DocNoteDo> getIcsNote(QueryIcsNoteDo queryIcsNoteDo) {
        return DOC_NOTE_MAPPER.getIcsNote(queryIcsNoteDo);
    }

    public List<DocNoteDo> getHdxNote(QueryHdxNoteDo queryHdxNoteDo) {
        return DOC_NOTE_MAPPER.getHdxNote(queryHdxNoteDo);
    }

    public List<DocNoteDo> getIcsNoteTopicId() {
        try {
            return DOC_NOTE_MAPPER.getIcsNoteTopicId();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.getIcsNoteTopicId Error", e);
            return Collections.emptyList();
        }
    }

    public List<DocNoteDo> getHdxNoteTopicId() {
        try {
            return DOC_NOTE_MAPPER.getHdxNoteTopicId();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.getHdxNoteTopicId Error", e);
            return Collections.emptyList();
        }
    }

    public List<DocNoteDo> getProduct() {
        return DOC_NOTE_MAPPER.getProduct();
    }

    public List<DocNoteDo> getHomeNotes(QueryHomeNoteDo queryHomeNoteDo) {
        return DOC_NOTE_MAPPER.getHomeNotes(queryHomeNoteDo);
    }

    public int getHomeNoteSize(QueryHomeNoteDo queryHomeNoteDo) {
        return DOC_NOTE_MAPPER.getHomeNoteSize(queryHomeNoteDo);
    }

    public List<DocNoteDo> getAllDocNotes() {
        return DOC_NOTE_MAPPER.getAllDocNotes();
    }

    public List<DocNoteDo> getDocNotesByRemarkIds(List<String> remarkIds) {
        return DOC_NOTE_MAPPER.getDocNotesByRemarkIds(remarkIds);
    }

    public void insertOrUpdateDocNotes(List<DocNoteDo> docNoteDos) {
        for (DocNoteDo docNoteDo : docNoteDos) {
            docNoteDo.setLibV((String)StringUtils.defaultIfEmpty((CharSequence)docNoteDo.getLibV(), (CharSequence)""));
            docNoteDo.setTopicUrl((String)StringUtils.defaultIfEmpty((CharSequence)docNoteDo.getTopicUrl(), (CharSequence)""));
            DOC_NOTE_MAPPER.insertOrUpdateDocNote(docNoteDo);
        }
    }

    public int update(DocNoteDo docNoteDo) {
        try {
            return DOC_NOTE_MAPPER.update(docNoteDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.update Error", e);
            return 0;
        }
    }

    public int updateHdxFlag(DocNoteDo docNoteDo) {
        return DOC_NOTE_MAPPER.updateHdxFlag(docNoteDo);
    }

    public int updateIcsFlag(DocNoteDo docNoteDo) {
        return DOC_NOTE_MAPPER.updateIcsFlag(docNoteDo);
    }

    public int del(String remarkId) {
        try {
            return DOC_NOTE_MAPPER.del(remarkId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DocNoteDaoHandler.del Error", e);
            return 0;
        }
    }

    public int delBatch(List<String> remarkIds) {
        return DOC_NOTE_MAPPER.delBatch(remarkIds);
    }

    private static class DocNoteDaoHandlerHolder {
        private static final DocNoteDaoHandler INSTANCE = new DocNoteDaoHandler();

        private DocNoteDaoHandlerHolder() {
        }
    }
}

