/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.bean;

import com.huawei.security.checkengine.bean.TreeNode;
import com.huawei.security.checkengine.bean.TrieTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AhoMappingWordsAutomaton {
    public static final TreeNode EMPTY_SET_NODE = TreeNode.createEmptyNode(null, -3, -2, -1);
    private final Map<Integer, TreeNode> failCache = new HashMap<Integer, TreeNode>();
    private final List<Integer> retrievalCacheNegate = new ArrayList<Integer>();
    private final Map<Integer, TreeNode> transitionCache = new HashMap<Integer, TreeNode>();
    private final TrieTree trieTree;

    public AhoMappingWordsAutomaton(TrieTree trie) {
        this.trieTree = trie;
    }

    public TreeNode fail(TreeNode tn) {
        if (tn == this.trieTree.getRootNode()) {
            this.failCache.put(tn.getID(), tn);
            return tn;
        }
        if (tn.getParent() == this.trieTree.getRootNode()) {
            this.failCache.put(tn.getID(), tn.getParent());
            return tn.getParent();
        }
        TreeNode resultNode = this.failCache.get(tn.getID());
        if (resultNode != null) {
            return resultNode;
        }
        char character = tn.getChar();
        TreeNode test = this.fail(tn.getParent());
        while (this.transition(test, character) == EMPTY_SET_NODE) {
            test = this.fail(test);
        }
        resultNode = this.transition(test, character);
        this.failCache.put(tn.getID(), resultNode);
        return resultNode;
    }

    public boolean isMatching(TreeNode node) {
        if (this.retrievalCacheNegate.contains(node.getID())) {
            return false;
        }
        if (node == this.trieTree.getRootNode()) {
            this.retrievalCacheNegate.add(node.getID());
            return false;
        }
        TreeNode nodeFail = this.fail(node);
        if (nodeFail != node && this.isMatching(nodeFail)) {
            return true;
        }
        if (node.isMarked()) {
            return true;
        }
        this.retrievalCacheNegate.add(node.getID());
        return false;
    }

    public TreeNode transition(TreeNode tn, char character) {
        TreeNode cachedResult;
        Integer combinedKeyCharacterAndID = tn.getID() * 1024 + character;
        if ("true".equals(System.getProperty("injectionValidatorSwitch"))) {
            combinedKeyCharacterAndID = tn.getID() * 65535 + character;
        }
        if ((cachedResult = this.transitionCache.get(combinedKeyCharacterAndID)) != null) {
            return cachedResult;
        }
        TreeNode testNode = tn.getFirstChild();
        while (!testNode.isEmptyChar()) {
            if (testNode.getChar() == character) {
                this.transitionCache.put(combinedKeyCharacterAndID, testNode);
                return testNode;
            }
            testNode = testNode.getBrother();
        }
        if (tn == this.trieTree.getRootNode()) {
            this.transitionCache.put(combinedKeyCharacterAndID, tn);
            return tn;
        }
        this.transitionCache.put(combinedKeyCharacterAndID, EMPTY_SET_NODE);
        return EMPTY_SET_NODE;
    }
}

