/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.engine;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.bean.BaseDefinitionClass;
import com.huawei.security.checkengine.exception.CheckEngineException;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.rulefile.AbstractBasedFileRuleFileLoader;
import com.huawei.security.checkengine.rulefile.ClasspathZipRuleFileLoader;
import com.huawei.security.checkengine.rulefile.FilesystemRuleFileLoader;
import com.huawei.security.checkengine.rulefile.RequestDefinitionContainer;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEngine.class);
    private static boolean classLoadRuleFileType = true;
    private static String ruleFilePath;
    protected Map<String, BaseDefinitionClass> definitionMap;

    public static void setRuleFileInfo(boolean classLoadRuleFileType, String ruleFilePath) {
        AbstractEngine.classLoadRuleFileType = classLoadRuleFileType;
        AbstractEngine.ruleFilePath = ruleFilePath;
    }

    public void check(Object input, CheckTypeEnum[] checkType, Object object) throws CheckEngineException {
        this.check(input, checkType, object, null);
    }

    public abstract void check(Object var1, CheckTypeEnum[] var2, Object var3, Properties var4) throws CheckEngineException;

    public abstract void init(CheckTypeEnum[] var1) throws RuleLoadingException;

    public void loadRule() throws RuleLoadingException {
        AbstractBasedFileRuleFileLoader ruleFileLoader = null;
        if (classLoadRuleFileType) {
            LOG.info("[WSF-CheckEngine] Init ClasspathZipRuleFileLoader.");
            ruleFileLoader = new ClasspathZipRuleFileLoader();
        } else {
            LOG.info("[WSF-CheckEngine] Init FilesystemRuleFileLoader.");
            ruleFileLoader = new FilesystemRuleFileLoader();
        }
        ruleFileLoader.setPath(ruleFilePath);
        RequestDefinitionContainer requestDefinitionContainer = new RequestDefinitionContainer(ruleFileLoader);
        requestDefinitionContainer.parseDefinitions();
        this.definitionMap = requestDefinitionContainer.getDefinitionMap();
        if (this.definitionMap == null) {
            LOG.error("[WSF-CheckEngine] Failed to init rule file map from the path.");
            throw new RuleLoadingException("Init rule file map failed.");
        }
    }

    protected BadRequestDefinition getDefinition(String definitionKey) throws CheckEngineException {
        BaseDefinitionClass definition = this.definitionMap.get(definitionKey);
        if (definition instanceof BadRequestDefinition) {
            return (BadRequestDefinition)definition;
        }
        LOG.error("[WSF-CheckEngine] Failed to get the check rules: {}", (Object)definitionKey);
        throw new CheckEngineException("Failed to get check rules.");
    }
}

