/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(GzipContentCheck.class);
    private static final String START_PATH = FileContentCheckUtil.getStartPath();
    private static byte[] dataBuffer = new byte[512];

    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean closeInputStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        if (checkRule == null) {
            throw new MultipartCheckException("Failed to parse check rules.");
        }
        try (GzipCompressorInputStream gzipCompressorInput = new GzipCompressorInputStream(fileContent);){
            ZipCheckParameter gzipParameter = new ZipCheckParameter(overrideProps, checkRule);
            boolean isDir = false;
            String filename = gzipCompressorInput.getMetaData().getFilename();
            if (filename == null) {
                LOG.error("[WSF-CheckEngine] File name is not match. The file name is: null.");
                throw new MultipartCheckException("Checking file content failed.");
            }
            filename = new String(filename.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            FileContentCheckUtil.checkFileName(filename, isDir, START_PATH, true, gzipParameter);
            this.checkFileTotalSize(gzipParameter.getMaxSize(), gzipCompressorInput);
        }
        catch (IOException e) {
            LOG.error("[WSF-CheckEngine] Failed to read the gzip file for checking.");
            throw new NotCheckContentException("Reading gzip file content failed IOException.");
        }
        finally {
            this.closeResource(fileContent, closeInputStream);
        }
    }

    private void closeResource(InputStream fileContent, boolean closeInputStream) {
        if (closeInputStream) {
            try {
                fileContent.close();
            }
            catch (IOException e) {
                LOG.error("[WSF-CheckEngine] Failed to close the gzip input stream.");
            }
        }
    }

    private void checkFileTotalSize(long maxSize, GzipCompressorInputStream input) throws MultipartCheckException, IOException {
        long res = 0L;
        int count = -1;
        while ((count = input.read(dataBuffer, 0, 512)) != -1) {
            if ((res += (long)count) <= maxSize) continue;
            LOG.error("[WSF-CheckEngine] File being ungzip is too big, the max size is: " + maxSize);
            throw new MultipartCheckException("Checking gzip file size failed.");
        }
    }
}

