/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.EngineSaxRead;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(XMLContentCheck.class);

    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean closeInputStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        if (checkRule == null) {
            throw new NotCheckContentException("Failed to find check rules with right type.");
        }
        if (checkRule.isPermissionDTD()) {
            LOG.error("[WSF-CheckEngine] PermissionDTD is {}, checkengine don't check xml content.", (Object)checkRule.isPermissionDTD());
            throw new NotCheckContentException("Check engine can not check xml content in DTD permission environment");
        }
        try (InputStreamReader reader = new InputStreamReader(fileContent, StandardCharsets.UTF_8);){
            EngineSaxRead sax = new EngineSaxRead();
            sax.read(reader);
        }
        catch (IOException | DocumentException e) {
            LOG.error("[WSF-CheckEngine] {}, rule file name: 2B_XML_XXE.ce.", (Object)checkRule.getDescription());
            throw new MultipartCheckException("Checking xml file failed.", e);
        }
        finally {
            if (closeInputStream) {
                try {
                    fileContent.close();
                }
                catch (IOException e) {
                    LOG.error("[WSF-CheckEngine] Close inputStream fail.");
                }
            }
        }
    }
}

