/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CheckTypeEnum {
    COMMAND_INJECTION("Command_Injection"),
    DIRECTORY_TRAVERSAL("Directory_Traversal"),
    LDAP_INJECTION("LDAP_Injection"),
    SQL_INJECTION("SQL_Injection"),
    XSS("xss"),
    XML("xml"),
    RAR("rar"),
    TAR("tar"),
    TARGZ("targz"),
    TARBZ2("tarbz2"),
    GZ("gz"),
    ZIP("zip"),
    XLSX("xlsx"),
    DOCX("docx"),
    OTHERTYPE("");

    private static final Logger LOG;
    private String value;

    private CheckTypeEnum(String value) {
        this.value = value;
    }

    public static CheckTypeEnum getEnumFromString(String checkTypeString) {
        if (checkTypeString == null) {
            return OTHERTYPE;
        }
        try {
            return CheckTypeEnum.valueOf(checkTypeString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            LOG.debug("[WSF-CheckEngine] Failing recognition for validator's class type.");
            return OTHERTYPE;
        }
    }

    public String getCheckTypeName() {
        return this.value;
    }

    static {
        LOG = LoggerFactory.getLogger(CheckTypeEnum.class);
    }
}

