/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import com.huawei.security.checkengine.bean.WordDictionaryClass;
import com.huawei.security.checkengine.util.WordMatchingTools;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerUtil {
    private static final int TRIE_MATCHING_THRSHOLD = 60;
    private static final Logger LOG = LoggerFactory.getLogger(ServerUtil.class);

    private ServerUtil() {
    }

    public static String cleanLog(String message) {
        return message == null ? "" : message.replace('\n', '_').replace('\r', '_');
    }

    public static boolean isVariantMatching(Map<String, String[]> valueMap, WordDictionaryClass preFilter, Pattern pattern) {
        if (valueMap == null) {
            return false;
        }
        if (pattern == null) {
            return false;
        }
        for (Map.Entry<String, String[]> checkValue : valueMap.entrySet()) {
            String[] values = checkValue.getValue();
            if (values == null || !ServerUtil.matching(values, preFilter, pattern)) continue;
            LOG.error("[WSF-CheckEngine] Exist attack risk.");
            return true;
        }
        return false;
    }

    private static boolean matching(String[] values, WordDictionaryClass preFilter, Pattern pattern) {
        for (String value : values) {
            if (value == null) continue;
            Matcher matcher = pattern.matcher(value);
            if (!WordMatchingTools.matchesWord(preFilter, value, 60) || !matcher.reset(value).find()) continue;
            return true;
        }
        return false;
    }
}

