/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.bean;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.ParameterConfigSet;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.ParameterSetNameInterface;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.validators.ValidatorFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ValidateRuleBean {
    private static final int INITIAL_CAPACITY = 3;
    private static final String DEFAULT_SET_KEY = "huawei.wsf.parameter.set.default";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private String url;
    private String failPath;
    private String errorHandler;
    private String dataPattern;
    private String conversionDataPattern;
    private String paramSetName;
    private Map<String, ParameterConfigSet> parameterSetMap = new HashMap<String, ParameterConfigSet>(3);
    private ParameterSetNameInterface paramSetNameInterface;
    private boolean needCheckBody = false;
    private String allParameterCheck;
    private int maxObjSize;

    public int getMaxObjSize() {
        return this.maxObjSize;
    }

    public void setMaxObjSize(int maxObjSize) {
        this.maxObjSize = maxObjSize;
    }

    public ParameterSetNameInterface getValidatorSetHandler() {
        return this.paramSetNameInterface;
    }

    public void setValidatorSetHandler(String validatorSetHandler) throws ValidateException {
        if (EmptyUtils.hasText(validatorSetHandler)) {
            this.paramSetNameInterface = ValidatorFactory.getParameterSetNameInterface(validatorSetHandler);
        }
    }

    public List<BasicParamConfigBean> getParamList(String requestParamSetName) throws ValidateException {
        ParameterConfigSet paramConfigSet = this.getParamConfigSet(requestParamSetName);
        if (paramConfigSet == null) {
            this.checkFileCache(requestParamSetName);
            for (ParameterConfigSet configSet : this.parameterSetMap.values()) {
                if (configSet == null) continue;
                return configSet.getNoteParamList();
            }
            LOG.error("[WSF-ParamValidate] Can't find match common parameter list, parameterSet name is {}.", (Object)LogUtils.cleanLog(this.getParameterSetKey(requestParamSetName)));
            throw new ValidateException("Can't find match common parameter list.");
        }
        return paramConfigSet.getNoteParamList();
    }

    private void checkFileCache(String requestParamSetName) throws ValidateException {
        LOG.error("[WSF-ParamValidate] ValidatorSetHandler return setName is not config, setName: {}.", (Object)LogUtils.cleanLog(requestParamSetName));
        if (FileCache.getInstance().getCommonConfigsBean().isCheckUserConfig()) {
            throw new ValidateException("Can't find match validatorSetHandler return setName. setName:" + LogUtils.cleanLog(requestParamSetName));
        }
    }

    private ParameterConfigSet getParamConfigSet(String requestParamSetName) throws ValidateException {
        if (EmptyUtils.isEmpty(this.parameterSetMap)) {
            LOG.error("[WSF-ParamValidate] The configured parameterSet list is empty.");
            throw new ValidateException("The configured parameterSet list is empty.");
        }
        return this.parameterSetMap.get(this.getParameterSetKey(requestParamSetName));
    }

    public List<BasicParamConfigBean> getUrlPathParamList(String requestParamSetName) throws ValidateException {
        if (EmptyUtils.isEmpty(this.parameterSetMap)) {
            throw new ValidateException("Can't find match parameterSet.");
        }
        ParameterConfigSet paramConfigSet = this.parameterSetMap.get(this.getParameterSetKey(requestParamSetName));
        if (paramConfigSet == null) {
            LOG.warn("[WSF-ParamValidate] Config name is error.");
            for (ParameterConfigSet configSet : this.parameterSetMap.values()) {
                if (configSet == null) continue;
                return configSet.getUrlPathParamList();
            }
            LOG.error("[WSF-ParamValidate] Can't find match url path parameter list, parameterSet name is {}.", (Object)LogUtils.cleanLog(this.getParameterSetKey(requestParamSetName)));
            throw new ValidateException("Can't find match url path parameter list.");
        }
        return paramConfigSet.getUrlPathParamList();
    }

    public List<BasicParamConfigBean> getXMLEntityParamList(String requestParamSetName) throws ValidateException {
        if (EmptyUtils.isEmpty(this.parameterSetMap)) {
            throw new ValidateException("Can't find match parameterSet.");
        }
        ParameterConfigSet paramConfigSet = this.parameterSetMap.get(this.getParameterSetKey(requestParamSetName));
        if (paramConfigSet == null) {
            LOG.warn("[WSF-ParamValidate] Config name is error.");
            for (ParameterConfigSet configSet : this.parameterSetMap.values()) {
                if (configSet == null) continue;
                return configSet.getXmlEntityParamList();
            }
            LOG.error("[WSF-ParamValidate] Can't find match xml entity parameter list, parameterSet name is {}.", (Object)LogUtils.cleanLog(this.getParameterSetKey(requestParamSetName)));
            throw new ValidateException("Can't find match xml entity parameter list.");
        }
        return paramConfigSet.getXmlEntityParamList();
    }

    public List<BasicParamConfigBean> getWildCardParamList(String requestParamSetName) throws ValidateException {
        if (EmptyUtils.isEmpty(this.parameterSetMap)) {
            throw new ValidateException("Can't find match parameterSet.");
        }
        ParameterConfigSet paramConfigSet = this.parameterSetMap.get(this.getParameterSetKey(requestParamSetName));
        if (paramConfigSet == null) {
            LOG.warn("[WSF-ParamValidate] Config name is error.");
            for (ParameterConfigSet configSet : this.parameterSetMap.values()) {
                if (configSet == null) continue;
                return configSet.getWildcardParamList();
            }
            LOG.error("[WSF-ParamValidate] Can't find match wild card parameter list, parameterSet name is {}.", (Object)LogUtils.cleanLog(this.getParameterSetKey(requestParamSetName)));
            throw new ValidateException("Can't find match wild card parameter list.");
        }
        return paramConfigSet.getWildcardParamList();
    }

    public List<BasicParamConfigBean> getQueryStringParamList(String requestParamSetName) throws ValidateException {
        ParameterConfigSet paramConfigSet = this.getParamConfigSet(requestParamSetName);
        if (paramConfigSet == null) {
            this.checkFileCache(requestParamSetName);
            for (ParameterConfigSet configSet : this.parameterSetMap.values()) {
                if (configSet == null) continue;
                return configSet.getQueryStringParamList();
            }
            LOG.error("[WSF-ParamValidate] Can't find matching QueryString parameter list, parameterSet name is {}.", (Object)LogUtils.cleanLog(this.getParameterSetKey(requestParamSetName)));
            throw new ValidateException("Can't find matching QueryString parameter list.");
        }
        return paramConfigSet.getQueryStringParamList();
    }

    public void addParameterSet(String key, ParameterConfigSet set) {
        this.parameterSetMap.put(this.getParameterSetKey(key), set);
    }

    public boolean hasParameterSet(String key) {
        return this.parameterSetMap.get(this.getParameterSetKey(key)) != null;
    }

    public String getParamSetName() {
        return this.paramSetName;
    }

    public void setParamSetName(String paramSetName) {
        this.paramSetName = paramSetName;
    }

    public String getDataPattern() {
        return this.dataPattern;
    }

    public void setDataPattern(String dataPattern) {
        this.dataPattern = dataPattern;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFailPath() {
        return this.failPath;
    }

    public void setFailPath(String failPath) {
        this.failPath = failPath;
    }

    public boolean isNeedCheckBody() {
        return this.needCheckBody;
    }

    public void setNeedCheckBody(boolean isNeedCheckBody) {
        this.needCheckBody = isNeedCheckBody;
    }

    public String getConversionDataPattern() {
        return this.conversionDataPattern;
    }

    public void setConversionDataPattern(String conversionDataPattern) {
        this.conversionDataPattern = conversionDataPattern;
    }

    public String getAllParameterCheck() {
        return this.allParameterCheck;
    }

    public void setAllParameterCheck(String allParameterCheck) {
        this.allParameterCheck = allParameterCheck;
    }

    private String getParameterSetKey(String requestParamSetName) {
        if (EmptyUtils.isEmpty(requestParamSetName)) {
            return DEFAULT_SET_KEY;
        }
        return requestParamSetName;
    }
}

