/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.bean;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValidatorEnum {
    ALPHA_VALIDATOR("com.huawei.security.validator.validators.AlphaValidator"),
    CREADITCARD_VALIDATOR("com.huawei.security.validator.validators.CreditCardValidator"),
    DIGITS_VALIDATOR("com.huawei.security.validator.validators.DigitsValidator"),
    EAMIL_VALIDATOR("com.huawei.security.validator.validators.EmailValidator"),
    EMAIL_VALIDATOR("com.huawei.security.validator.validators.EmailValidator"),
    IP_VALIDATOR("com.huawei.security.validator.validators.IPValidator"),
    MAX_LENGTH_VALIDATOR("com.huawei.security.validator.validators.MaxLengthValidator"),
    MIN_LENGTH_VALIDATOR("com.huawei.security.validator.validators.MinLengthValidator"),
    RANGE_LENGTH_VALIDATOR("com.huawei.security.validator.validators.RangeLengthValidator"),
    MAX_VALIDATOR("com.huawei.security.validator.validators.MaxValidator"),
    MIN_VALIDATOR("com.huawei.security.validator.validators.MinValidator"),
    RANGE_VALIDATOR("com.huawei.security.validator.validators.RangeValidator"),
    REGEXP_VALIDATOR("com.huawei.security.validator.validators.RegExpValidator"),
    EMPTY_VALIDATOR("com.huawei.security.validator.validators.EmptyValidator"),
    PASSWORD_COMPLEX_VALIDATOR("com.huawei.security.validator.validators.PasswdComplexValidator"),
    SQL_ATTACK_VALIDATOR("com.huawei.security.validator.validators.SQLValidator"),
    XSS_ATTACK_VALIDATOR("com.huawei.security.validator.validators.XSSValidator"),
    CHARACTER_WHITE_VALIDATOR("com.huawei.security.validator.validators.CharacterWhiteValidator"),
    BLACK_VALIDATOR("com.huawei.security.validator.validators.BlackValidator"),
    INJECTION_ATTACK_VALIDATOR("com.huawei.security.validator.validators.InjectionAttackValidator"),
    SAME_DOMAIN_VALIDATOR("com.huawei.security.validator.validators.SameDomainValidator"),
    USER_DEFINED_VALIDATOR("");

    private static final Logger LOG;
    private String value;

    private ValidatorEnum(String value) {
        this.value = value;
    }

    public static ValidatorEnum getEnumFromString(String validatorType) {
        if (validatorType == null) {
            return USER_DEFINED_VALIDATOR;
        }
        try {
            return ValidatorEnum.valueOf(validatorType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            LOG.error("[WSF-ParamValidate] Failing recognition for validator's class type.");
            return USER_DEFINED_VALIDATOR;
        }
    }

    public String getClassName() {
        return this.value;
    }

    static {
        LOG = LoggerFactory.getLogger(ValidatorEnum.class);
    }
}

