/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.config.AbstractRuleFileLoad;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LineIterator;
import com.huawei.security.validator.util.Resources;
import com.huawei.security.validator.util.WSFSaxRead;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;

public class ClassLoadZipConfigFile
extends AbstractRuleFileLoad {
    private static final int VALIDATE_PARAM_MAP_SIZE = 128;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final String DEFAULT_PATH = "validate.zip";
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    @Override
    public void loadConfigFile() throws ValidateException {
        if (EmptyUtils.isEmpty(this.path)) {
            this.path = DEFAULT_PATH;
            LOG.info("[WSF-ParamValidate] The config path is null, use default: {}.", (Object)DEFAULT_PATH);
        }
        this.validateParamMap = new HashMap(128);
        this.validateRuleSizeMap = new HashMap(128);
        this.parseCombinedValidators();
        this.parseCommonConfig();
        this.parseValidateTemplate();
        this.parseValidateRule();
    }

    private void parseCommonConfig() throws ValidateException {
        try (InputStream in = Resources.getResourceAsStream(this.path);
             ZipInputStream zin = new ZipInputStream(new BufferedInputStream(in));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zin.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!zipEntry.isDirectory() && entryName != null && entryName.endsWith("validate-common-config.xml")) {
                    LOG.debug("[WSF-ParamValidate] Begin parse validate-common-config.xml.");
                    Document document = this.readDocument(zin);
                    this.parseCommonConfigXml(document, "classpath:" + entryName);
                    LOG.debug("[WSF-ParamValidate] End parse validate-common-config.xml.");
                }
                zin.closeEntry();
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse validate-common-config.xml in zip.", ex);
        }
    }

    private void parseValidateTemplate() throws ValidateException {
        try (InputStream in = Resources.getResourceAsStream(this.path);
             ZipInputStream zin = new ZipInputStream(new BufferedInputStream(in));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zin.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!zipEntry.isDirectory() && entryName != null && this.checkTemplatePrefixAndSuffix(entryName)) {
                    LOG.debug("[WSF-ParamValidate] Begin parse validate-template: {}.", (Object)entryName);
                    Document document = this.readDocument(zin);
                    this.parseParamTemplate(document.getRootElement());
                    LOG.debug("[WSF-ParamValidate] End parse validate-template: {}.", (Object)entryName);
                }
                zin.closeEntry();
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-template file in zip.", ex);
        }
    }

    private void parseCombinedValidators() throws ValidateException {
        try (InputStream in = Resources.getResourceAsStream(this.path);
             BufferedInputStream bis = new BufferedInputStream(in);
             ZipInputStream zin = new ZipInputStream(bis);){
            ZipEntry zipEntry = null;
            while ((zipEntry = zin.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!zipEntry.isDirectory() && entryName != null && this.checkValidatorsPrefixAndSuffix(entryName)) {
                    LOG.debug("[WSF-ParamValidate] Begin parse validate-validator: {}.", (Object)entryName);
                    Document document = this.readDocument(zin);
                    this.parseValidatorsTemplates(document.getRootElement());
                    LOG.debug("[WSF-ParamValidate] End parse validate-validator: {}.", (Object)entryName);
                }
                zin.closeEntry();
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-validator file in zip.", ex);
        }
    }

    private void parseValidateRule() throws ValidateException {
        try (InputStream in = Resources.getResourceAsStream(this.path);
             ZipInputStream zin = new ZipInputStream(new BufferedInputStream(in));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zin.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!zipEntry.isDirectory() && entryName != null && this.checkFilePrefixAndSuffix(entryName)) {
                    LOG.debug("[WSF-ParamValidate] Begin parse validate-rule: {}.", (Object)entryName);
                    Document document = this.readDocument(zin);
                    this.addParamValidators(document.getRootElement());
                    LOG.debug("[WSF-ParamValidate] End parse validate-rule: {}.", (Object)entryName);
                }
                zin.closeEntry();
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-rule file in zip.", ex);
        }
    }

    private Document readDocument(ZipInputStream zin) throws IOException, DocumentException {
        StringBuilder sb = new StringBuilder(16);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)zin, CHARSET));
        LineIterator lineIte = new LineIterator(reader);
        while (lineIte.hasNext()) {
            String tempString = lineIte.next();
            sb.append(tempString);
        }
        byte[] content = sb.toString().getBytes(CHARSET);
        Document doc = null;
        try (InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(content), CHARSET);){
            WSFSaxRead wsfReader = new WSFSaxRead();
            doc = wsfReader.read(in);
        }
        return doc;
    }
}

