/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.filter;

import com.huawei.security.validator.ValidatorManager;
import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.RootParamValidatorsBean;
import com.huawei.security.validator.bean.ValidateFileConfig;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.config.AbstractRuleFileLoad;
import com.huawei.security.validator.config.ClassLoadJarConfigFile;
import com.huawei.security.validator.config.ClassLoadZipConfigFile;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.config.LoadConfigFile;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.filter.FilterHttpServletRequest;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.ValidateErrorHandler;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.InternalMessage;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.OmSwitch;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidateFailErrorUtil;
import com.huawei.security.validator.util.ValidateSecurityConfiguration;
import com.huawei.security.validator.validators.ValidatorFactory;
import com.huawei.security.validator.web.HttpParameter;
import com.huawei.security.validator.web.JsonParameter;
import com.huawei.security.validator.web.QueryStringParameter;
import com.huawei.security.validator.web.UrlPathParameter;
import com.huawei.security.validator.web.XmlParameter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class ParamCheckFilter
extends GenericFilterBean {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final String MULTIPART = "multipart/";
    private static final int SYMBOLS_INDEX_NOT_EXIST = -1;
    private final CommonConfigsBean configsBean = FileCache.getInstance().getCommonConfigsBean();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private ValidatorManager validatorManager;
    private ValidateFileConfig fileConfig;
    private ValidateSecurityConfiguration configuration;
    private String omPropertyFilePath = "";
    private OmSwitch instance;

    public ParamCheckFilter() {
        this(null);
    }

    public ParamCheckFilter(ValidateFileConfig config) {
        if (config == null) {
            return;
        }
        LOG.info("[WSF-ParamValidate] Constructor init param config.");
        this.fileConfig = config;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filter) throws IOException, ServletException {
        boolean contentTypeSwitch = false;
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if (!EmptyUtils.isEmpty(closeSwitch = this.instance.getProperty("ParamCheckFilter"))) {
                String[] switchArr = closeSwitch.split("#");
                if (switchArr.length == 2 && "contentType".equals(switchArr[1])) {
                    contentTypeSwitch = true;
                }
                if ("OFF".equalsIgnoreCase(switchArr[0])) {
                    LOG.warn("[WSF-ParamValidate] OM Scenario ParamCheckFilter is skipping.");
                    filter.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
        }
        HttpServletRequest request = this.requestDowncast(servletRequest);
        HttpServletResponse response = this.responseDowncast(servletResponse);
        String requestUri = this.processUri(request);
        LOG.debug("[WSF-ParamValidate] Enter validate filter, Request uri is {}, method is {}.", (Object)LogUtils.cleanLog(requestUri), (Object)LogUtils.cleanLog(request.getMethod()));
        this.internalMessage(response.getLocale());
        ValidateRuleBean bean2 = this.validatorManager.getValidateObject(requestUri, request.getMethod(), request.getContentType(), this.fileConfig, contentTypeSwitch);
        if (bean2 == null) {
            this.doForward(request, requestUri, response, filter);
            return;
        }
        if (this.checkUploadFilterOrder(request)) {
            LOG.error("[WSF-ParamValidate] Data validate module don't support the multipart data.");
            Map<String, ValidatorResult> resultMap = ValidateFailErrorUtil.creatFileUploadValidationError();
            this.processValidateFail(resultMap, request, response, bean2, filter);
            return;
        }
        if ((request = (HttpServletRequest)this.processParamCheck(request, response, bean2, filter, requestUri).orElse(null)) == null) {
            return;
        }
        filter.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    private Optional<HttpServletRequest> processParamCheck(HttpServletRequest httpServletRequest, HttpServletResponse response, ValidateRuleBean bean2, FilterChain filter, String requestUri) throws IOException, ServletException {
        Object request = httpServletRequest;
        try {
            boolean isNeedCheckBody;
            LOG.debug("[WSF-ParamValidate] Data validate begin.");
            String dataPattern = bean2.getDataPattern();
            String bodyData = "";
            boolean bl = isNeedCheckBody = !"form".equalsIgnoreCase(dataPattern) || "form".equalsIgnoreCase(dataPattern) && this.configsBean.isFormBodyCheck();
            if (isNeedCheckBody) {
                boolean isEqualsDataPattern;
                LOG.debug("[WSF-ParamValidate] Wrapper the http servlet request.");
                FilterHttpServletRequest filterRequest = new FilterHttpServletRequest((HttpServletRequest)request);
                bodyData = filterRequest.getBody();
                request = filterRequest;
                boolean bl2 = isEqualsDataPattern = "json_conversion_form".equalsIgnoreCase(dataPattern) || "xml_conversion_form".equalsIgnoreCase(dataPattern);
                if (isEqualsDataPattern && EmptyUtils.isEmpty(bodyData) && bean2.isNeedCheckBody()) {
                    LOG.error("[WSF-ParamValidate] Http body is null, it is not permitted.");
                    this.processValidateFail(ValidateFailErrorUtil.creatParseRequestDataException(), (HttpServletRequest)request, response, bean2, filter);
                    return Optional.of(request);
                }
                if (isEqualsDataPattern) {
                    dataPattern = this.getDataPattern(bean2, bodyData);
                }
            }
            LOG.debug("[WSF-ParamValidate] Request data pattern is: {}.", (Object)dataPattern);
            PublicData publicData = this.getRequestData(bean2, requestUri, (HttpServletRequest)request, dataPattern, bodyData);
            Parameter paramObject = this.getRequestParam(bean2, requestUri, (HttpServletRequest)request, dataPattern, bodyData);
            this.validatorManager.validatorParam(paramObject, bean2, publicData);
        }
        catch (ValidateException e) {
            LOG.error("[WSF-ParamValidate] ParamCheckFilter occur exception, {}", (Object)e.getMessage());
            this.processValidateFail(ValidateFailErrorUtil.creatOccurUnknownException(), (HttpServletRequest)request, response, bean2, filter);
            return Optional.empty();
        }
        catch (ParseRequestDataException e) {
            LOG.error("[WSF-ParamValidate] Parse request data occur exception, data validate fail, {}", (Object)e.getMessage());
            this.processValidateFail(ValidateFailErrorUtil.creatParseRequestDataException(), (HttpServletRequest)request, response, bean2, filter);
            return Optional.empty();
        }
        catch (ParamValueValidateFailException e) {
            this.processValidateFail(e.getResultMap(), (HttpServletRequest)request, response, bean2, filter);
            return Optional.empty();
        }
        LOG.debug("[WSF-ParamValidate] Data validate end, validate success.");
        return Optional.of(request);
    }

    private String getDataPattern(ValidateRuleBean bean2, String bodyData) {
        String dataPattern = EmptyUtils.isEmpty(bodyData) ? "conversionform" : bean2.getConversionDataPattern();
        return dataPattern;
    }

    @Override
    protected void initFilterBean() throws ServletException {
        if (super.getFilterConfig() != null && this.fileConfig == null) {
            LOG.info("[WSF-ParamValidate] Load web.xml init param config.");
            this.fileConfig = new ValidateFileConfig(super.getFilterConfig());
        }
        String contextPath = this.getContextPath();
        String propertyFilePath = "";
        String configPath = "";
        AbstractRuleFileLoad fileLoad = null;
        if (this.fileConfig == null) {
            LOG.info("[WSF-ParamValidate] Not set init param in filter.");
            propertyFilePath = contextPath + "WEB-INF" + File.separator;
            configPath = propertyFilePath + "validate" + File.separator;
            fileLoad = new LoadConfigFile();
        } else {
            LOG.info("[WSF-ParamValidate] Have been set file path info.");
            propertyFilePath = this.fileConfig.getPropertiesFilePath();
            configPath = this.fileConfig.getValidateFilePath();
            this.omPropertyFilePath = this.fileConfig.getOmPropertyFilePath();
            String loadFileMethod = this.fileConfig.getLoadFileMethod();
            if ("zip".equals(loadFileMethod)) {
                fileLoad = new ClassLoadZipConfigFile();
            } else if ("jar".equals(loadFileMethod)) {
                fileLoad = new ClassLoadJarConfigFile();
            } else {
                configPath = configPath == null ? "WEB-INF" : configPath;
                configPath = contextPath + configPath + File.separator + "validate" + File.separator;
                fileLoad = new LoadConfigFile();
            }
        }
        this.initOmFunction();
        try {
            fileLoad.setPath(configPath);
            fileLoad.loadConfigFile();
        }
        catch (ValidateException e) {
            LOG.error("[WSF-ParamValidate] Load validator config files fail. {}", (Object)e.getMessage());
            throw new ServletException("Load validator config files fail.", (Throwable)e);
        }
        FileCache.getInstance().clearTemplates();
        FileCache.getInstance().setRuleFile(fileLoad);
        FileCache.getInstance().setFileConfig(this.fileConfig);
        this.validatorManager = new ValidatorManager();
        this.configuration = ValidateSecurityConfiguration.getInstance(propertyFilePath);
    }

    private String getContextPath() {
        String contextPath = this.getServletContext().getRealPath("/");
        if (contextPath == null) {
            LOG.error("[WSF-ParamValidate] Can't get servletContext real path.");
            contextPath = "";
        }
        if (!contextPath.endsWith(File.separator)) {
            contextPath = contextPath + File.separator;
        }
        return contextPath;
    }

    @Override
    public void destroy() {
        this.validatorManager = null;
        this.configuration = null;
    }

    public ValidateFileConfig getFileConfig() {
        return this.fileConfig;
    }

    public void setFileConfig(ValidateFileConfig fileConfig) {
        this.fileConfig = fileConfig;
    }

    private void internalMessage(Locale locale) {
        LOG.info("[WSF-ParamValidate] Init internal message.");
        InternalMessage.setLocaleValue(locale);
        String i18nBaseName = this.configsBean.getI18nBaseName();
        if (i18nBaseName != null) {
            InternalMessage.init(i18nBaseName);
        } else {
            ClassLoader loader = this.getServletContext().getClassLoader();
            String contextPath = this.getServletContext().getRealPath("/");
            InternalMessage.init(loader, contextPath);
        }
    }

    private void processValidateFail(Map<String, ValidatorResult> resultMap, HttpServletRequest request, HttpServletResponse response, ValidateRuleBean bean2, FilterChain filter) throws ServletException {
        block6: {
            try {
                response.setStatus(FileCache.getInstance().getRootParamBean().getStateCode());
                String handler = bean2.getErrorHandler();
                if (EmptyUtils.hasText(handler)) {
                    LOG.error("[WSF-ParamValidate] Parameter validate fail, ValidateErrorHandler: {} process result.", (Object)handler);
                    try {
                        ValidateErrorHandler handlerInst = ValidatorFactory.getValidateHandler(handler);
                        handlerInst.handler(request, response, new HashMap<String, Object>(resultMap));
                    }
                    catch (ValidateException e) {
                        LOG.error("[WSF-ParamValidate] Instance ValidateErrorHandler occurred exception, {}.", (Object)e.getMessage());
                    }
                    if (!this.configsBean.isInterceptOnFailed()) {
                        filter.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                    break block6;
                }
                this.setRequestAttribute(resultMap, request);
                this.doForward(request, response, bean2.getFailPath());
            }
            catch (IOException e) {
                LOG.error("[WSF-ParamValidate] An unknown exception occurred: IOException.");
            }
        }
    }

    private void setRequestAttribute(Map<String, ValidatorResult> resultMap, HttpServletRequest request) {
        for (ValidatorResult result : resultMap.values()) {
            List<ErrorMessage> errorList;
            if (result.isValidateResule() || (errorList = result.getErrorMessageParams()).isEmpty()) continue;
            String errorKey = errorList.get(0).getErrorKey();
            String errorMessage = errorList.get(0).getErrorMessage();
            if (errorKey == null || errorMessage == null) continue;
            request.setAttribute(errorKey, (Object)errorMessage);
        }
    }

    private void doForward(HttpServletRequest request, HttpServletResponse response, String failPath) {
        response.setContentType("text/html;charset=UTF-8");
        String errorPage = failPath;
        if (EmptyUtils.isEmpty(errorPage)) {
            LOG.info("[WSF-ParamValidate] Haven't config error page, user default: {}.", (Object)LogUtils.cleanLog(errorPage));
            errorPage = "/validate_error.html";
        }
        LOG.error("[WSF-ParamValidate] Parameter validate fail, forward to error page: {}.", (Object)LogUtils.cleanLog(errorPage));
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(errorPage);
            if (dispatcher == null) {
                LOG.error("[WSF-ParamValidate] dispatcher is null");
                return;
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            LOG.error("[WSF-ParamValidate] Forward to error page occur exception: ServletException or IOException.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doForward(HttpServletRequest request, String requestUri, HttpServletResponse response, FilterChain filter) throws IOException, ServletException {
        RootParamValidatorsBean rootParam = FileCache.getInstance().getRootParamBean();
        boolean isWhiteList = false;
        List<String> excludeValidateUrlList = rootParam.getExcludeUrlPattern();
        for (String url : excludeValidateUrlList) {
            if (!this.matcher.match(url, requestUri)) continue;
            LOG.debug("[WSF-ParamValidate] White list contains the request url {}.", (Object)LogUtils.cleanLog(requestUri));
            isWhiteList = true;
        }
        LOG.debug("[WSF-ParamValidate] AllUrlCheck config is {}.", (Object)rootParam.isAllUrlCheck());
        if (rootParam.isAllUrlCheck()) {
            if (!isWhiteList) {
                LOG.error("[WSF-ParamValidate] URL {} didn't included in white list, validate fail.", (Object)LogUtils.cleanLog(requestUri));
                response.setStatus(rootParam.getStateCode());
                String handler = rootParam.getErrorHandlerClassName();
                this.doHandler(request, response, rootParam, handler);
                return;
            }
            LOG.debug("[WSF-ParamValidate] Skip validate, because of URL included in white list.");
        } else {
            if (isWhiteList) {
                LOG.debug("[WSF-ParamValidate] Request uri:{}, can't find validate rule. Method is {}.", (Object)LogUtils.cleanLog(requestUri), (Object)LogUtils.cleanLog(request.getMethod()));
            } else {
                LOG.warn("[WSF-ParamValidate] Request uri:{}, can't find validate rule. Method is {}.", (Object)LogUtils.cleanLog(requestUri), (Object)LogUtils.cleanLog(request.getMethod()));
            }
            LOG.debug("[WSF-ParamValidate] Data validate end, validate success.");
        }
        filter.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void doHandler(HttpServletRequest request, HttpServletResponse response, RootParamValidatorsBean rootParam, String handler) {
        if (EmptyUtils.hasText(handler)) {
            LOG.error("[WSF-ParamValidate] Parameter validate fail, ValidateErrorHandler: {} process result.", (Object)LogUtils.cleanLog(handler));
            try {
                ValidateErrorHandler handlerInst = ValidatorFactory.getValidateHandler(handler);
                Map<String, ValidatorResult> resultMap = ValidateFailErrorUtil.creatNotConfigCheckUrlError();
                handlerInst.handler(request, response, new HashMap<String, Object>(resultMap));
            }
            catch (ValidateException e) {
                LOG.error("[WSF-ParamValidate] Instance ValidateErrorHandler occured exception, {}.", (Object)e.getMessage());
            }
        } else {
            this.doForward(request, response, rootParam.getFailPath());
        }
    }

    private String processUri(HttpServletRequest request) {
        String requestUri = request.getServletPath();
        if (request.getPathInfo() != null) {
            requestUri = requestUri + request.getPathInfo();
        }
        if (this.configsBean.isAddAppName()) {
            requestUri = this.getServletContext().getContextPath() + requestUri;
        }
        if (requestUri.endsWith("/")) {
            requestUri = requestUri.substring(0, requestUri.length() - 1);
        }
        return requestUri;
    }

    private PublicData getRequestData(ValidateRuleBean bean2, String requestUrl, HttpServletRequest request, String dataPattern, String bodyData) {
        PublicData publicData = new PublicData();
        publicData.setRequestParamSetName(Optional.ofNullable(bean2.getValidatorSetHandler()).map(handler -> handler.getParameterSetName(request)).orElse(null));
        publicData.setRequestData(request.getParameterMap());
        publicData.setQueryString(request.getQueryString());
        String configUrl = bean2.getUrl();
        String characterEncoding = request.getCharacterEncoding();
        if (configUrl.indexOf(123) != -1 && configUrl.indexOf(125) != -1) {
            UrlPathParameter urlPathParameter = new UrlPathParameter(requestUrl, characterEncoding);
            if (this.matcher.match(configUrl, requestUrl)) {
                urlPathParameter.setUrlPathMap(this.matcher.extractUriTemplateVariables(configUrl, requestUrl));
            } else {
                LOG.error("[WSF-ParamValidate] ConfigUri is not match the request uri.");
            }
            publicData.setUrlPathParameter(urlPathParameter);
        }
        if ("json".equals(dataPattern)) {
            publicData.setJsonData(bodyData);
            publicData.setQueryStringParameter(new QueryStringParameter(request, requestUrl));
            return publicData;
        }
        if ("xml".equals(dataPattern)) {
            publicData.setXmlData(bodyData);
            publicData.setQueryStringParameter(new QueryStringParameter(request, requestUrl));
        }
        return publicData;
    }

    private Parameter getRequestParam(ValidateRuleBean bean2, String requestUrl, HttpServletRequest request, String dataPattern, String bodyData) {
        if ("json".equals(dataPattern)) {
            return new JsonParameter(bean2, request, bodyData, requestUrl);
        }
        if ("xml".equals(dataPattern)) {
            return new XmlParameter(request, bodyData, requestUrl);
        }
        if ("conversionform".equals(dataPattern)) {
            return new QueryStringParameter(request, requestUrl);
        }
        return new HttpParameter(request, requestUrl);
    }

    private boolean checkUploadFilterOrder(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        if (contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART)) {
            try {
                if (this.isAssignableFromRequestClass(request)) {
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("[WSF-ParamValidate] Class not found, {}", (Object)e.getMessage());
            }
            return true;
        }
        return false;
    }

    private boolean isAssignableFromRequestClass(HttpServletRequest request) throws ClassNotFoundException {
        HttpServletRequest servletRequest = request;
        while (servletRequest instanceof HttpServletRequestWrapper) {
            LOG.debug("[WSF-ParamValidate] Request class is {}.", (Object)servletRequest.getClass().getName());
            for (String uploadClass : this.configuration.getUploadClassList()) {
                Class<?> upload = Class.forName(uploadClass);
                if (!upload.isAssignableFrom(servletRequest.getClass())) continue;
                return true;
            }
            servletRequest = ((HttpServletRequestWrapper)servletRequest).getRequest();
        }
        return false;
    }

    private HttpServletRequest requestDowncast(ServletRequest servletRequest) throws ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            return (HttpServletRequest)servletRequest;
        }
        throw new ServletException("[WSF-ParamValidate] Request downcast failed.");
    }

    private HttpServletResponse responseDowncast(ServletResponse servletResponse) throws ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            return (HttpServletResponse)servletResponse;
        }
        throw new ServletException("[WSF-ParamValidate] Response downcast failed.");
    }
}

