/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.filter;

import com.huawei.security.validator.bean.HeaderParam;
import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.config.RequestHeaderValidteConfig;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseValidateConfigException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.RequestHeaderProcessValidate;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.OmSwitch;
import com.huawei.security.validator.util.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class RequestHeaderCheckFilter
implements Filter {
    private static final String VALIDATE_CONFIG_FILE = "requestheader_validate_config.xml";
    private static final String VALIDATE_CONFIGRELITIVE_PATH = "/validate";
    private static final String CONFIG_FILEPATH_FILTER_PATH = "validate_file_path";
    private static final String OM_PROPERTY_FILE_PATH = "propertyFilePath";
    private static final String DYNAMIC_SWITCH = "dynamicSwitch";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private String customConfigFileDir = null;
    private String omPropertyFilePath = "";
    private OmSwitch instance;
    private RequestHeaderProcessValidate requestHeaderValidate = new RequestHeaderProcessValidate();
    private RequestHeaderValidteConfig validateConf = new RequestHeaderValidteConfig();

    public RequestHeaderCheckFilter() {
        this(null);
    }

    public RequestHeaderCheckFilter(String customConfFileDir) {
        this.customConfigFileDir = customConfFileDir;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filter) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, filter)) {
            return;
        }
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            try {
                List<HeaderParam> validateRules = this.validateConf.getValidateRuleList();
                this.requestHeaderValidate.validatorParam(validateRules, request);
            }
            catch (ParamValueValidateFailException e) {
                this.validateConf.getValidateFailedHandler().handle(request, response, e);
                return;
            }
            catch (ValidateException e) {
                LOG.error("[WSF-HeaderValidate] Request header validate occur exception: {}", (Object)e.getMessage());
                ParamValueValidateFailException ex = new ParamValueValidateFailException(e.getMessage());
                this.validateConf.getValidateFailedHandler().handle(request, response, ex);
                return;
            }
        }
        filter.doFilter(servletRequest, servletResponse);
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filter) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty(DYNAMIC_SWITCH);
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("RequestHeaderCheckFilter"))) {
                LOG.warn("[WSF-HeaderValidate] OM Scenario RequestHeaderCheckFilter is skipping.");
                filter.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String customDir = filterConfig.getInitParameter(CONFIG_FILEPATH_FILTER_PATH);
        this.omPropertyFilePath = filterConfig.getInitParameter(OM_PROPERTY_FILE_PATH);
        this.initOmFunction();
        if (EmptyUtils.hasLength(customDir)) {
            this.customConfigFileDir = customDir;
        }
        try (InputStream in = this.getFileResource(VALIDATE_CONFIG_FILE, this.customConfigFileDir, VALIDATE_CONFIGRELITIVE_PATH);){
            this.validateConf.initConfig(in);
        }
        catch (ParseValidateConfigException ex) {
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServletException("Could not find config file.", (Throwable)ex);
        }
    }

    public void destroy() {
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public InputStream getFileResource(String filename, String customDirectory, String resourceDirectory) throws IOException {
        LOG.debug("[WSF-HeaderValidate] Attempting to load config file: {} as resource file via file I/O.", (Object)filename);
        if (filename == null) {
            LOG.error("[WSF-HeaderValidate] Failed to load properties via FileIO. Filename is null.");
            throw new IOException("Could not find resource, filename is null.");
        }
        if (customDirectory != null) {
            File configFile = FileUtil.getFile(customDirectory, filename);
            if (configFile.canRead()) {
                LOG.debug("[WSF-HeaderValidate] Found config file in customDirectory directory, configFile canRead.");
                return new FileInputStream(configFile);
            }
            configFile = FileUtil.getFile(customDirectory + resourceDirectory, filename);
            if (configFile.canRead()) {
                LOG.debug("[WSF-HeaderValidate] Found config file in customDirectory directory.");
                return new FileInputStream(configFile);
            }
            LOG.debug("[WSF-HeaderValidate] Not found config file in customDirectory directory {}.", (Object)"or config file not readable");
        }
        return Resources.getResourceAsStream(resourceDirectory + "/" + filename);
    }
}

