/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.bean.XMLParamNumberCheckBean;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.InternalMessage;
import com.huawei.security.validator.util.JsonParseFactory;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PathUtil;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidateFailErrorUtil;
import com.huawei.security.validator.util.ValidatorUtil;
import com.huawei.security.validator.util.XMLProcessUtil;
import com.huawei.security.validator.web.HttpParameter;
import com.huawei.security.validator.web.XmlParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.slf4j.Logger;

public class FormProcessValidate
extends AbstractProcessValidate {
    private static final int RESULT_MAP_SIZE = 4;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private ValidateRuleBean validateObject;
    private PublicData publicData;

    public FormProcessValidate(ValidateRuleBean validateRuleBean, PublicData publicData) {
        this.validateObject = validateRuleBean;
        this.publicData = publicData;
    }

    @Override
    public void validatorParam(Parameter paramObject) throws ParamValueValidateFailException, ParseRequestDataException, ValidateException {
        if (this.validateObject == null) {
            LOG.info("[WSF-ParamValidate] Don't need validate parameter.");
            return;
        }
        if (!(paramObject instanceof HttpParameter)) {
            throw new ValidateException("The parameter type is not as expected.");
        }
        Map<String, List<String>> requestParamValueMap = ((HttpParameter)paramObject).getAllParamList();
        HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(4);
        try {
            List<BasicParamConfigBean> formNoteList = this.validateObject.getParamList(this.publicData.getRequestParamSetName());
            this.publicData.setDecodePattern(paramObject.getPattern());
            if (formNoteList != null) {
                for (BasicParamConfigBean basicParamConfigBean : formNoteList) {
                    this.processFormNode(requestParamValueMap, resultMap, basicParamConfigBean);
                }
            }
        }
        catch (ValidateException ex) {
            this.validateExceptionProcess(resultMap, ex);
        }
        List<BasicParamConfigBean> noteList = this.validateObject.getWildCardParamList(this.publicData.getRequestParamSetName());
        if (!EmptyUtils.isEmpty(noteList)) {
            LOG.info("[WSF-ParamValidate] Need to validate wildcard parameter.");
            this.validateWildcardParameter(requestParamValueMap, resultMap, paramObject.getPattern(), noteList);
        }
        if (this.isAllParamCheck(this.validateObject, this.configsBean.isFormAllParamCheck())) {
            this.checkRequestParamNum(requestParamValueMap.keySet());
        }
    }

    private void validateWildcardParameter(Map<String, List<String>> requestParamValueMap, Map<String, ValidatorResult> resultMap, String pattern, List<BasicParamConfigBean> noteList) throws ValidateException, ParamValueValidateFailException {
        for (BasicParamConfigBean wildcardParam : noteList) {
            ParameterConfigBean parameterObject = null;
            if (!(wildcardParam instanceof ParameterConfigBean)) {
                LOG.error("[WSF-ParamValidate] WildCardParamList contains object which is not ParameterConfigBean.");
                continue;
            }
            parameterObject = (ParameterConfigBean)wildcardParam;
            String wildcardParamName = parameterObject.getName();
            boolean isRequired = parameterObject.isRequired();
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            if (!this.isNeedCheck(isRequired, wildcardParamName, requestParamValueMap, error, resultMap)) continue;
            boolean isMatching = false;
            Pattern paramNamePattern = Pattern.compile(wildcardParamName);
            Iterator<Map.Entry<String, List<String>>> iterator = requestParamValueMap.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isOptionalEmptyValue;
                Map.Entry<String, List<String>> requestParamEntry = iterator.next();
                String requestParamName = requestParamEntry.getKey();
                List<String> requestParams = requestParamEntry.getValue();
                if (!paramNamePattern.matcher(requestParamName).matches()) continue;
                isMatching = true;
                boolean decoding = Boolean.parseBoolean(parameterObject.getDecode());
                List<String> valueList = this.decodeParamValue(requestParams, decoding, pattern);
                boolean isRequiredEmptyValue = EmptyUtils.isEmpty(valueList) && isRequired;
                boolean bl = isOptionalEmptyValue = EmptyUtils.isEmpty(valueList) && !isRequired;
                if (isRequiredEmptyValue) {
                    this.emptyRequiredHandler(requestParamName, error, resultMap);
                }
                if (isOptionalEmptyValue) {
                    this.emptyNotRequiredHandler(resultMap, wildcardParamName);
                    iterator.remove();
                    continue;
                }
                this.validateParam(requestParamName, parameterObject, valueList, this.publicData, resultMap);
                iterator.remove();
            }
            this.paramNotMatchedHandler(resultMap, wildcardParamName, isRequired, error, isMatching);
        }
    }

    private void paramNotMatchedHandler(Map<String, ValidatorResult> resultMap, String wildcardParamName, boolean isRequired, ErrorMessage error, boolean isMatching) throws ParamValueValidateFailException {
        if (!isMatching) {
            if (isRequired) {
                this.emptyRequiredHandler(wildcardParamName, error, resultMap);
            } else {
                this.emptyNotRequiredHandler(resultMap, wildcardParamName);
            }
        }
    }

    private void processFormNode(Map<String, List<String>> paramValueMap, Map<String, ValidatorResult> resultMap, BasicParamConfigBean basicParamConfigBean) throws ParamValueValidateFailException, ValidateException, ParseRequestDataException {
        if (basicParamConfigBean instanceof ParameterConfigBean) {
            ParameterConfigBean parameterObject = (ParameterConfigBean)basicParamConfigBean;
            String paramName = parameterObject.getName();
            String paramPattern = parameterObject.getDataPattern();
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            if (!this.isNeedCheck(parameterObject.isRequired(), paramName, (Collection<String>)paramValueMap.get(paramName), error, resultMap)) {
                paramValueMap.remove(paramName);
                return;
            }
            List<String> paramValueDecode = this.decodeParamValue(paramValueMap.get(paramName), Boolean.parseBoolean(parameterObject.getDecode()), this.publicData.getDecodePattern());
            if (EmptyUtils.isEmpty(paramPattern)) {
                LOG.info("[WSF-ParamValidate] Data pattern is form or get.");
                this.validateParam(paramName, parameterObject, paramValueDecode, this.publicData, resultMap);
            } else if ("json".equalsIgnoreCase(paramPattern)) {
                LOG.info("[WSF-ParamValidate] Form data pattern is json.");
                this.checkMaxArraySize(resultMap, paramValueDecode.size(), basicParamConfigBean, paramName);
                this.processJsonData(parameterObject, paramValueDecode, resultMap, paramValueMap);
            } else if ("xml".equalsIgnoreCase(paramPattern)) {
                LOG.info("[WSF-ParamValidate] Form data pattern is xml.");
                this.checkMaxArraySize(resultMap, paramValueDecode.size(), basicParamConfigBean, paramName);
                this.processXmlData(parameterObject, paramValueDecode, resultMap, paramValueMap);
            } else {
                this.paramValuePatternError(parameterObject, paramPattern, resultMap);
            }
            paramValueMap.remove(paramName);
        }
    }

    private void processJsonData(ParameterConfigBean parameterObject, List<String> paramValueDecode, Map<String, ValidatorResult> resultMap, Map<String, List<String>> paramValueMap) throws ParamValueValidateFailException, ValidateException, ParseRequestDataException {
        String paramName = parameterObject.getName();
        ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
        List<BasicParamConfigBean> jsonParamList = parameterObject.getChildParamList();
        if (EmptyUtils.isEmpty(jsonParamList)) {
            this.emptyListHandler(resultMap, paramName, error);
        }
        for (String paramValue : paramValueDecode) {
            if (!this.isRequire(parameterObject.isRequired(), paramValue)) {
                paramValueMap.remove(paramName);
                continue;
            }
            if (paramValue == null) {
                this.emptyRequiredHandler(paramName, error, resultMap);
            }
            this.publicData.setJsonData(paramValue);
            HashMap<String, List<String>> jsonInfoMap = new HashMap<String, List<String>>(16);
            JsonParseInterface jsonParser = JsonParseFactory.getJsonParser();
            Object json = jsonParser.getJsonObject(paramValue);
            if (!jsonParser.isEmptyJson(json)) {
                ArrayList<String> needCheckParamList = new ArrayList<String>();
                ArrayList<String> noNeedCheckParamList = new ArrayList<String>();
                JsonUtil.handleCheckParamList(jsonParamList, needCheckParamList, noNeedCheckParamList);
                JsonUtil.initCheckParamList(needCheckParamList, noNeedCheckParamList, jsonInfoMap);
                jsonParser.traverseJsonData(json, jsonInfoMap, "");
                if (jsonInfoMap.get("checkResult#@#").get(0).equals("1")) {
                    JsonUtil.cleanCheckParamList(jsonInfoMap);
                    throw new ValidateException("JSON data consistency check failed.");
                }
                JsonUtil.cleanCheckParamList(jsonInfoMap);
            }
            this.processJsonNodeList(jsonParamList, resultMap, jsonInfoMap, this.publicData);
            this.checkJsonParamNum(jsonInfoMap, this.validateObject);
        }
    }

    private void emptyListHandler(Map<String, ValidatorResult> resultMap, String paramName, ErrorMessage error) throws ParamValueValidateFailException {
        LOG.error("[WSF-ParamValidate] The child parameter's list is empty, paramName: {}", (Object)LogUtils.cleanLog(paramName));
        ValidatorResult result = new ValidatorResult(false);
        error.setErrorMessage(InternalMessage.getMessage(error.getErrorMessage()));
        error.setErrorCode("NOT_CONFIG_PARAMETER_VALIDATOR");
        result.addErrorMessageParams(error);
        resultMap.put(paramName, result);
        ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
    }

    private void processXmlData(ParameterConfigBean parameterObject, List<String> paramValueDecode, Map<String, ValidatorResult> resultMap, Map<String, List<String>> paramValueMap) throws ParamValueValidateFailException, ValidateException, ParseRequestDataException {
        String paramName = parameterObject.getName();
        ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
        List<BasicParamConfigBean> xmlParamList = parameterObject.getChildParamList();
        if (EmptyUtils.isEmpty(xmlParamList)) {
            this.emptyListHandler(resultMap, paramName, error);
        }
        for (String paramValue : paramValueDecode) {
            if (!this.isRequire(parameterObject.isRequired(), paramValue)) {
                paramValueMap.remove(paramName);
                continue;
            }
            if (paramValue == null) {
                this.emptyRequiredHandler(paramName, error, resultMap);
            }
            this.publicData.setXmlData(paramValue);
            this.validateXmlEntity(parameterObject.getXmlEntityParamList(), this.publicData, LogUtils.isContainXmlEntity(paramValue), resultMap);
            Document doc = XMLProcessUtil.getXMLDocument(paramValue);
            XmlParameter xmlParameter = new XmlParameter();
            xmlParameter.setDoc(doc);
            if (this.isAllParamCheck(this.validateObject, this.configsBean.isXmlAllParamCheck())) {
                Map<String, XMLParamNumberCheckBean> xmlNodeMap = XMLProcessUtil.getAllXPath(doc);
                this.xmlParamValidator(xmlParamList, xmlNodeMap, xmlParameter, resultMap, this.publicData);
                this.checkXmlParamNumber(this.validateObject, xmlNodeMap, xmlParameter, xmlParamList);
                continue;
            }
            this.validatorParam(resultMap, xmlParamList, PathUtil.parse(doc).orElse(null), PathUtil.getNameSpaces(doc));
        }
    }

    private void validatorParam(Map<String, ValidatorResult> resultMap, List<BasicParamConfigBean> xmlParamList, org.w3c.dom.Document doc, Map<String, String> map) throws ParamValueValidateFailException, ValidateException, ParseRequestDataException {
        for (BasicParamConfigBean childParam : xmlParamList) {
            boolean childIsRequired = childParam.isRequired();
            String xmlParamName = childParam.getName();
            ErrorMessage childError = new ErrorMessage(childParam.getErrorKey(), childParam.getErrorMessage());
            List<String> validateValueList = XMLProcessUtil.getXMLParamValue(doc, map, xmlParamName);
            if (!this.isNeedCheck(childIsRequired, xmlParamName, validateValueList, childError, resultMap)) continue;
            this.validateParam(xmlParamName, childParam, validateValueList, this.publicData, resultMap);
        }
    }

    private void paramValuePatternError(ParameterConfigBean parameterObject, String paramPattern, Map<String, ValidatorResult> resultMap) throws ParamValueValidateFailException {
        ErrorMessage error = new ErrorMessage();
        error.setErrorKey(parameterObject.getErrorKey());
        error.setErrorMessage(parameterObject.getErrorMessage());
        error.setErrorCode("PARAM_PATTERN_TYPE_ERROR");
        ValidatorResult resultParam = ValidatorUtil.getValidateResult(error);
        String paramName = parameterObject.getName();
        resultMap.put(paramName, resultParam);
        LOG.error("[WSF-ParamValidate] Data pattern is {}, validate is not support.", (Object)LogUtils.cleanLog(paramPattern));
        LOG.error("[WSF-ParamValidate] ParamName:{}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
        ParamValueValidateFailException ex = new ParamValueValidateFailException();
        ex.setResultMap(resultMap);
        throw ex;
    }

    private void checkRequestParamNum(Set<String> paramNameSet) throws ParamValueValidateFailException {
        LOG.info("[WSF-ParamValidate] Form need validate parameter number.");
        Set<String> excludeRequestSet = this.configsBean.getExcludeParam();
        for (String paramName : paramNameSet) {
            if (excludeRequestSet.contains(paramName)) continue;
            LOG.error("[WSF-ParamValidate] Whitelist is not contain the parameter name, not config parameter name is {}.", (Object)LogUtils.cleanLog(paramName));
            ValidateFailErrorUtil.throwParamConfigValidateFailException(paramName);
        }
    }
}

