/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidateFailErrorUtil;
import com.huawei.security.validator.web.QueryStringParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class QueryStringProcessValidate
extends AbstractProcessValidate {
    private static final int RESULT_MAP_SIZE = 4;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private ValidateRuleBean validateObject;
    private PublicData publicData;

    public QueryStringProcessValidate(ValidateRuleBean validateRuleBean, PublicData publicData) {
        this.validateObject = validateRuleBean;
        this.publicData = publicData;
    }

    @Override
    public void validatorParam(Parameter paramObject) throws ParamValueValidateFailException, ValidateException {
        LOG.debug("[WSF-ParamValidate] Begin validate querystring parameter.");
        if (this.validateObject == null) {
            return;
        }
        HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(4);
        List<BasicParamConfigBean> noteList = null;
        try {
            noteList = this.validateObject.getQueryStringParamList(this.publicData.getRequestParamSetName());
        }
        catch (ValidateException ex) {
            this.validateExceptionProcess(resultMap, ex);
        }
        QueryStringParameter queryStringParameter = null;
        if (!(paramObject instanceof QueryStringParameter)) {
            throw new ValidateException("The parameter type is not as expected.");
        }
        queryStringParameter = (QueryStringParameter)paramObject;
        Map<String, List<String>> queryStringParamValueMap = queryStringParameter.getAllParamList();
        HashSet<String> paramNameSet = new HashSet<String>(queryStringParamValueMap.keySet());
        if (noteList != null) {
            for (BasicParamConfigBean basicParamConfigBean : noteList) {
                this.removeParam(paramObject, resultMap, queryStringParamValueMap, paramNameSet, basicParamConfigBean);
            }
        }
        this.checkRequestParamNum(paramNameSet, this.validateObject.getUrl());
    }

    private void removeParam(Parameter paramObject, HashMap<String, ValidatorResult> resultMap, Map<String, List<String>> queryStringParamValueMap, Set<String> paramNameSet, BasicParamConfigBean basicParamConfigBean) throws ParamValueValidateFailException, ValidateException {
        if (basicParamConfigBean instanceof ParameterConfigBean) {
            ParameterConfigBean parameterObject = (ParameterConfigBean)basicParamConfigBean;
            String paramName = parameterObject.getName();
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            if (!this.isNeedCheck(parameterObject.isRequired(), paramName, (Collection<String>)queryStringParamValueMap.get(paramName), error, resultMap)) {
                paramNameSet.remove(paramName);
                return;
            }
            List<String> paramValueDecode = this.decodeParamValue(queryStringParamValueMap.get(paramName), Boolean.parseBoolean(parameterObject.getDecode()), paramObject.getPattern());
            this.validateParam(paramName, parameterObject, paramValueDecode, this.publicData, resultMap);
            paramNameSet.remove(paramName);
        }
    }

    protected void checkRequestParamNum(Set<String> paramNameSet, String url) throws ParamValueValidateFailException {
        if (!this.isAllParamCheck(this.validateObject, this.configsBean.isQueryStringAllParamCheck())) {
            return;
        }
        LOG.info("[WSF-ParamValidate] QueryString need validate parameter number.");
        if (paramNameSet.isEmpty()) {
            return;
        }
        Set<String> queryStringSet = this.configsBean.getExcludeQueryStingParamMap().get(url);
        if (EmptyUtils.isEmpty(queryStringSet)) {
            queryStringSet = this.configsBean.getPublicQueryStringParam();
        }
        paramNameSet.removeAll(queryStringSet);
        if (!paramNameSet.isEmpty()) {
            LOG.error("[WSF-ParamValidate] Config parameter is incomplete, validate fail.");
            Iterator<String> iterator = paramNameSet.iterator();
            if (iterator.hasNext()) {
                String paramName = iterator.next();
                LOG.error("[WSF-ParamValidate] Not config name is {}.", (Object)LogUtils.cleanLog(paramName));
                ParamValueValidateFailException ex = new ParamValueValidateFailException();
                ex.setResultMap(ValidateFailErrorUtil.creatValidateParamConfigError(paramName));
                throw ex;
            }
        }
    }
}

