/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidateFailErrorUtil;
import com.huawei.security.validator.web.UrlPathParameter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class UrlPathProcessValidate
extends AbstractProcessValidate {
    private static final int RESULT_MAP_SIZE = 4;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private ValidateRuleBean validateObject;
    private PublicData publicData;

    public UrlPathProcessValidate(ValidateRuleBean validateRuleBean, PublicData publicData) {
        this.validateObject = validateRuleBean;
        this.publicData = publicData;
    }

    @Override
    public void validatorParam(Parameter paramObject) throws ParamValueValidateFailException, ValidateException {
        LOG.debug("[WSF-ParamValidate] Begin validate url path parameter.");
        if (this.validateObject != null) {
            UrlPathParameter urlPathParameter = null;
            if (!(paramObject instanceof UrlPathParameter)) {
                throw new ValidateException("The parameter type is not as expected.");
            }
            urlPathParameter = (UrlPathParameter)paramObject;
            List<BasicParamConfigBean> noteList = this.validateObject.getUrlPathParamList(this.publicData.getRequestParamSetName());
            HashMap<String, String> urlParamValueMap = new HashMap<String, String>(urlPathParameter.getUrlPathMap());
            HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(4);
            for (BasicParamConfigBean basicParamConfigBean : noteList) {
                if (!(basicParamConfigBean instanceof ParameterConfigBean)) continue;
                ParameterConfigBean parameterObject = (ParameterConfigBean)basicParamConfigBean;
                String paramName = parameterObject.getName();
                boolean urlPathValueNeedDecode = parameterObject.isUrlParamDecode();
                String charaSet = parameterObject.getCharSet();
                paramName = paramName.substring(1, paramName.length() - 1);
                String urlPathValue = (String)urlParamValueMap.remove(paramName);
                ArrayList<String> valueList = new ArrayList<String>(10);
                urlPathValue = this.decodeUrlPathValue(urlPathValueNeedDecode, charaSet, urlPathValue);
                valueList.add(urlPathValue);
                this.validateParam(paramName, parameterObject, valueList, this.publicData, resultMap);
            }
            this.checkUrlPathParamNum(urlParamValueMap.keySet());
        } else {
            LOG.info("[WSF-ParamValidate] Don't need validate parameter.");
        }
    }

    private String decodeUrlPathValue(boolean urlPathValueNeedDecode, String charaSet, String urlPathValue) throws ValidateException {
        String urlTempValue;
        try {
            urlTempValue = urlPathValueNeedDecode ? new String(Base64.getDecoder().decode(urlPathValue), charaSet) : urlPathValue;
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("[WSF-ParamValidate] The url param charset is invalid, please check you config.");
            throw new ValidateException();
        }
        return urlTempValue;
    }

    private void checkUrlPathParamNum(Set<String> paramNameSet) throws ParamValueValidateFailException {
        if (!this.isAllParamCheck(this.validateObject, this.configsBean.isUrlPathAllParamCheck())) {
            return;
        }
        LOG.info("[WSF-ParamValidate] Need validate url path parameter number.");
        Set<String> excludeUrlPathSet = this.configsBean.getExcludeUrlPathParam();
        for (String paramName : paramNameSet) {
            if (excludeUrlPathSet.contains(paramName)) continue;
            LOG.error("[WSF-ParamValidate] Whitelist is not contain the parameter name, not config parameter name is {}.", (Object)LogUtils.cleanLog(paramName));
            ParamValueValidateFailException ex = new ParamValueValidateFailException();
            ex.setResultMap(ValidateFailErrorUtil.creatValidateParamConfigError(paramName));
            throw ex;
        }
    }
}

