/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.outerinterface;

import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractXMLValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    public abstract ValidatorResult validate(String var1, Object var2, HashMap<String, String> var3, String var4, String var5);

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] AbstractXMLValidator:Input validate parameter value is null, so the result is false.");
            ValidatorResult result = new ValidatorResult();
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, "PARAM_VALUE_CANNOT_NULL", new Object[0]);
            return result;
        }
        if (inputValidate instanceof PublicData) {
            PublicData publicData = (PublicData)inputValidate;
            Map<String, String[]> paramMap = publicData.getRequestData();
            return this.validate(publicData.getXmlData(), paramMap, validateRuleMap, errorKey, errorMessage);
        }
        ValidatorResult result = new ValidatorResult();
        LOG.error("[WSF-ParamValidate] AbstractUrlPathValidator: Input validate parameter failed in downcasting.");
        ValidatorUtil.setErrorResult(result, errorKey, errorMessage, "PARAM_PATTERN_TYPE_ERROR", new Object[0]);
        return result;
    }
}

