/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.log.WSFValidatorLog;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import org.slf4j.Logger;

public class ClassLoaderWrapper {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private ClassLoader systemClassLoader;

    ClassLoaderWrapper() {
        try {
            this.systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException ignore) {
            LOG.error("[WSF-ParamValidate] Failed to get system class loader.");
        }
    }

    public URL getResourceAsURL(String resource) {
        return this.getResourceAsURL(resource, this.getClassLoaders(null));
    }

    public URL getResourceAsURL(String resource, ClassLoader loader) {
        return this.getResourceAsURL(resource, this.getClassLoaders(loader));
    }

    public URL getResourceAsURL(String resource, ClassLoader[] loaders) {
        return this.getOptionalURL(resource, loaders).orElse(null);
    }

    private Optional<URL> getOptionalURL(String resource, ClassLoader[] loaders) {
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            URL resourceURL = loader.getResource(resource);
            if (resourceURL == null) {
                resourceURL = loader.getResource("/" + resource);
            }
            if (resourceURL == null) continue;
            return Optional.of(resourceURL);
        }
        return Optional.empty();
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getResourceAsStream(resourceName, this.getClassLoaders(null));
    }

    public InputStream getResourceAsStream(String resourceName, ClassLoader loader) {
        return this.getResourceAsStream(resourceName, this.getClassLoaders(loader));
    }

    public InputStream getResourceAsStream(String resource, ClassLoader[] loaders) {
        return this.getOptionalResourceAsStream(resource, loaders).orElse(null);
    }

    private Optional<InputStream> getOptionalResourceAsStream(String resource, ClassLoader[] loaders) {
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            InputStream in = loader.getResourceAsStream(resource);
            if (in == null) {
                in = loader.getResourceAsStream("/" + resource);
            }
            if (in == null) continue;
            return Optional.of(in);
        }
        return Optional.empty();
    }

    private ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), this.systemClassLoader};
    }
}

