/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public class GsonJsonProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private int level = -1;

    @Override
    public Object getJsonObject(String gsonJsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(gsonJsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject String for converting to FastJson is Empty.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        try {
            String trimJsonObjectStr = gsonJsonObjectStr.trim();
            if (trimJsonObjectStr.startsWith("{")) {
                MapJsonDeserializer jsonMap = new MapJsonDeserializer();
                Type type = new MapTypeToken().getType();
                Gson gson = new GsonBuilder().registerTypeAdapter(type, (Object)jsonMap).create();
                return gson.fromJson(trimJsonObjectStr, type);
            }
            if (trimJsonObjectStr.startsWith("[")) {
                ListJsonDeserializer jsonList = new ListJsonDeserializer();
                Type type = new ListTypeToken().getType();
                Gson gson = new GsonBuilder().registerTypeAdapter(type, (Object)jsonList).create();
                return gson.fromJson(trimJsonObjectStr, type);
            }
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("Gson failed to parse JSONObject String.");
        }
        catch (JsonParseException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("Gson parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Gson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public boolean isEmptyJson(Object json) throws ParseRequestDataException {
        if (json == null) {
            throw new ParseRequestDataException("The Json object is null.");
        }
        if (json instanceof Map) {
            Map jsonObj = (Map)json;
            return jsonObj.isEmpty();
        }
        if (json instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)json;
            return jsonObj.size() == 0;
        }
        if (json instanceof List) {
            List jsonObj = (List)json;
            return jsonObj.isEmpty();
        }
        if (json instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)json;
            return jsonArray.size() == 0;
        }
        LOG.error("[WSF-ParamValidate] The input object is not belong to Json.");
        return false;
    }

    @Override
    public void traverseJsonData(Object json, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        try {
            if (json instanceof Map) {
                Map jsonMap = (Map)json;
                this.handleMap(dataMap, completeKey, jsonMap);
            } else if (json instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)json;
                this.handleJsonObject(dataMap, completeKey, jsonObject);
            } else if (json instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)json;
                this.handleJsonArray(dataMap, completeKey, jsonArray);
            } else if (json instanceof List) {
                List jsonList = (List)json;
                this.handleList(dataMap, completeKey, jsonList);
            } else {
                this.processJsonValue(json, dataMap, completeKey);
            }
        }
        catch (ClassCastException ex) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Traverse json data occur exception.", ex);
        }
    }

    private void handleMap(Map<String, List<String>> dataMap, String completeKey, Map<?, ?> jsonMap) throws ParseRequestDataException {
        String completeKeyTmp = completeKey;
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonMap.isEmpty()) {
            JsonUtil.handleEmpty(completeKeyTmp, dataMap);
        }
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) + 1)));
        for (Map.Entry<?, ?> entry : jsonMap.entrySet()) {
            String key = String.valueOf(entry.getKey());
            JsonElement element = null;
            Object value = entry.getValue();
            if (value instanceof JsonElement) {
                element = (JsonElement)value;
            }
            completeKeyTmp = completeKeyTmp + "@#9#%*@" + key;
            this.traverseJsonData(element, dataMap, completeKeyTmp);
            completeKeyTmp = completeKeyTmp.substring(0, completeKeyTmp.lastIndexOf("@#9#%*@"));
        }
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) - 1)));
    }

    private void handleJsonObject(Map<String, List<String>> dataMap, String completeKey, JsonObject jsonObject) throws ParseRequestDataException {
        String completeKeyTmp = completeKey;
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonObject.size() == 0) {
            JsonUtil.handleEmpty(completeKeyTmp, dataMap);
        }
        this.initNeedCheckParamByGson(dataMap, completeKey);
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) + 1)));
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            completeKeyTmp = completeKeyTmp + "@#9#%*@" + key;
            this.traverseJsonData(element, dataMap, completeKeyTmp);
            completeKeyTmp = completeKeyTmp.substring(0, completeKeyTmp.lastIndexOf("@#9#%*@"));
        }
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) - 1)));
        int gsonCurrDeep = Integer.parseInt(dataMap.get("deepIndex#@#").get(0));
        if (gsonCurrDeep == this.level && this.level != -1 && dataMap.get("needCheckParam#@#").size() > 0) {
            JsonUtil.handleDataMapOutOfJsonArray(dataMap, completeKey);
        }
    }

    private void initNeedCheckParamByGson(Map<String, List<String>> dataMap, String completeKey) {
        if (dataMap.get("needCheckParamFormValue#@#") == null && dataMap.get("needCheckParam#@#").size() > 0) {
            List<String> xmlParamList = dataMap.get("needCheckParam#@#");
            List<String> needCheckParamList = JsonUtil.convertParamListFromCurrentKey(xmlParamList);
            this.level = JsonUtil.getJsonKeyLevel(completeKey, xmlParamList);
            dataMap.put("needCheckParamFormObj#@#", new ArrayList<String>(needCheckParamList));
        }
    }

    private void handleJsonArray(Map<String, List<String>> dataMap, String completeKey, JsonArray jsonArray) throws ParseRequestDataException {
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonArray.size() == 0) {
            JsonUtil.handleEmpty(completeKey, dataMap);
        }
        for (JsonElement element : jsonArray) {
            this.traverseJsonData(element, dataMap, completeKey);
        }
    }

    private void handleList(Map<String, List<String>> dataMap, String completeKey, List<?> jsonList) throws ParseRequestDataException {
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonList.isEmpty()) {
            JsonUtil.handleEmpty(completeKey, dataMap);
        }
        for (Object jsonObject : jsonList) {
            this.traverseJsonData(jsonObject, dataMap, completeKey);
        }
    }

    private <T> void processJsonValue(T json, Map<String, List<String>> dataMap, String completeKey) {
        String completeKeySub = completeKey.length() < "@#9#%*@".length() ? "" : completeKey.substring("@#9#%*@".length());
        String completeKeyReplaced = completeKeySub.replace("@#9#%*@", ".");
        if (dataMap.containsKey(completeKeyReplaced)) {
            dataMap.get(completeKeyReplaced).add(this.getAsString(json).orElse(null));
        } else {
            ArrayList<Object> valueList = new ArrayList<Object>(10);
            valueList.add(this.getAsString(json).orElse(null));
            dataMap.put(completeKeyReplaced, valueList);
        }
        JsonUtil.handleParamListRefJsonKey(dataMap, completeKeyReplaced);
    }

    private <T> Optional<String> getAsString(T json) {
        if (json == null) {
            return Optional.empty();
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            return Optional.ofNullable(jsonPrimitive.getAsString());
        }
        return Optional.ofNullable(json.toString());
    }

    private static class ListJsonDeserializer
    implements JsonDeserializer<List<Object>> {
        private ListJsonDeserializer() {
        }

        public List<Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray jsonArray = json.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>(jsonArray.size());
            for (Object item : jsonArray) {
                list.add(item);
            }
            return list;
        }
    }

    private static class MapJsonDeserializer
    implements JsonDeserializer<Map<String, Object>> {
        private MapJsonDeserializer() {
        }

        public Map<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            HashMap<String, Object> treeMap = new HashMap<String, Object>(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                treeMap.put((String)entry.getKey(), entry.getValue());
            }
            return treeMap;
        }
    }

    private static class ListTypeToken
    extends TypeToken<List<Object>> {
        private ListTypeToken() {
        }
    }

    private static class MapTypeToken
    extends TypeToken<Map<String, Object>> {
        private MapTypeToken() {
        }
    }
}

