/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.jackson.JsonJacksonUtil;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonProcessUtils;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonValue;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class JacksonPerformanceProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public Object getJsonObject(String jsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject Sting for translating is empty.");
            throw new ParseRequestDataException("JackSon Failed to parse JSONObject String.");
        }
        try {
            String notEmptyJsonObjectStr = jsonObjectStr.trim();
            ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
            JsonNode jsonValue = objectMapper.readTree(notEmptyJsonObjectStr);
            return new JsonValue(jsonValue);
        }
        catch (JsonProcessingException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject Sting has not correct Json struct.");
            throw new ParseRequestDataException("JackSon Failed to parse JSONObject String.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("JackSon failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public void traverseJsonData(Object json, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        if (!(json instanceof JsonValue)) {
            throw new ParseRequestDataException("Jackson Object not instance JsonValue.");
        }
        JsonBaseCore source = (JsonBaseCore)json;
        JsonProcessUtils.jsonTraverse(dataMap, source);
    }

    @Override
    public boolean isEmptyJson(Object jacksonJson) throws ParseRequestDataException {
        if (jacksonJson == null) {
            throw new ParseRequestDataException("jackson content is null.");
        }
        if (jacksonJson instanceof JsonValue) {
            JsonValue jacksonValue = (JsonValue)jacksonJson;
            if (jacksonValue.isArray()) {
                JsonArray jacksonArray = jacksonValue.asArray();
                return jacksonArray.isEmpty();
            }
            if (jacksonValue.isObject()) {
                JsonObject jacksonObject = jacksonValue.asObject();
                return jacksonObject.isEmpty();
            }
        }
        LOG.error("[WSF-ParamValidate] The jackson input object is not belong to Json.");
        return false;
    }
}

