/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.exception.NullReaderException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class LineIterator
implements Closeable {
    private final BufferedReader bufferReader;
    private String cachedLineStr;
    private boolean isFinished;

    public LineIterator(Reader reader) throws NullReaderException {
        if (reader == null) {
            throw new NullReaderException("Reader can not be null, please check the reader");
        }
        this.bufferReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public boolean hasNext() {
        if (this.cachedLineStr != null) {
            return true;
        }
        if (this.isFinished) {
            return false;
        }
        try {
            String line = this.bufferReader.readLine();
            if (line == null) {
                this.isFinished = true;
                return false;
            }
            this.cachedLineStr = line;
            return true;
        }
        catch (IOException exception) {
            LineIterator.closeQuietly(this, exception::addSuppressed);
            throw new NullReaderException("readLine occur error");
        }
    }

    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator hasn't more lines");
        }
        String currentLineStr = this.cachedLineStr;
        this.cachedLineStr = null;
        return currentLineStr;
    }

    @Override
    public void close() throws IOException {
        this.isFinished = true;
        this.cachedLineStr = null;
        this.bufferReader.close();
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }
}

