/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class OrgJsonProcess {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    public static void checkJsonDuplicateKey(String jsonString) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonString)) {
            LOG.error("[WSF-ParamValidate] The JSONObject String for converting to OrgJson is Empty.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        try {
            String notEmptyJsonObjectStr = jsonString.trim();
            if (notEmptyJsonObjectStr.startsWith("{")) {
                new JSONObject(jsonString);
                return;
            }
            if (notEmptyJsonObjectStr.startsWith("[")) {
                new JSONArray(jsonString);
                return;
            }
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct: OrgJson check.");
            throw new ParseRequestDataException("OrgJson parse json occur exception.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct: OrgJson check.");
            throw new ParseRequestDataException("OrgJson parse json occur exception.", e);
        }
        catch (ClassCastException e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception: OrgJson check.");
            throw new ParseRequestDataException("OrgJson failed to parse JSONObject Sting.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("OrgJson failed to parse JSONObject Sting.", e);
        }
    }
}

