/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.ClassLoaderWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;

public final class Resources {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static ClassLoaderWrapper classLoaderWrapper = new ClassLoaderWrapper();

    private Resources() {
    }

    public static Properties getResourceAsProperties(String resource) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Resources.getResourceAsStream(resource);){
            properties.load(in);
        }
        return properties;
    }

    public static Properties getResourceAsProperties(ClassLoader loader, String resource) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Resources.getResourceAsStream(loader, resource);){
            properties.load(in);
        }
        return properties;
    }

    public static InputStream getResourceAsStream(String streamResource) throws IOException {
        return Resources.getResourceAsStream(null, streamResource);
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String resource) throws IOException {
        InputStream in = classLoaderWrapper.getResourceAsStream(resource, classLoader);
        if (in == null) {
            if (resource != null && resource.endsWith("wsf-validate.properties")) {
                LOG.warn("Could not find resource {}", (Object)resource);
            } else {
                LOG.error("Could not find resource {}", (Object)resource);
            }
            throw new IOException("Could not find resource");
        }
        return in;
    }

    public static URL getResourceURL(String resource) throws IOException {
        return Resources.getResourceURL(null, resource);
    }

    public static URL getResourceURL(ClassLoader classLoader, String resourceName) throws IOException {
        URL url = classLoaderWrapper.getResourceAsURL(resourceName, classLoader);
        if (url != null) {
            return url;
        }
        LOG.error("Could not find resource {}", (Object)resourceName);
        throw new IOException("Could not find resource");
    }
}

