/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public final class ValidateSecurityConfiguration {
    public static final String FILE_NAME = "wsf-validate.properties";
    public static final String UPLOAD_CLASS = "uploadclass";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static volatile ValidateSecurityConfiguration instance = null;
    private Properties properties = new Properties();
    private List<String> uploadClassList = new ArrayList<String>(10);

    private ValidateSecurityConfiguration(String propertyFile) {
        LOG.info("[WSF-ParamValidate] Attempting to load properties file: {}.", (Object)propertyFile);
        try (FileInputStream inputStream = new FileInputStream(propertyFile + File.separator + FILE_NAME);){
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            String propertyFilePath = EmptyUtils.isEmpty(propertyFile) ? FILE_NAME : propertyFile + "/" + FILE_NAME;
            LOG.info("[WSF-ParamValidate] Load {} failed, Attempting to load from {}.", (Object)propertyFile, (Object)propertyFilePath);
            try (InputStream inputStream2 = Resources.getResourceAsStream(propertyFilePath);){
                this.properties.load(inputStream2);
            }
            catch (IOException ex) {
                LOG.info("[WSF-ParamValidate] Could not find wsf-validate.properties from {}.", (Object)propertyFilePath);
            }
        }
        String uploadClass = this.properties.getProperty(UPLOAD_CLASS);
        if (EmptyUtils.hasText(uploadClass)) {
            String[] uploadClassArray = uploadClass.split(";");
            this.uploadClassList.addAll(Arrays.asList(uploadClassArray));
            this.uploadClassList.remove("javax.servlet.http.HttpServletRequestWrapper");
            this.uploadClassList.remove("javax.servlet.ServletRequestWrapper");
            this.uploadClassList.remove("javax.servlet.http.HttpServletRequest");
        }
        this.uploadClassList.add("com.huawei.security.upload.servlet.SecurityUploadHttpServletRequest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ValidateSecurityConfiguration getInstance(String propertyFile) {
        if (instance != null) return instance;
        Class<ValidateSecurityConfiguration> clazz = ValidateSecurityConfiguration.class;
        synchronized (ValidateSecurityConfiguration.class) {
            if (instance != null) return instance;
            instance = new ValidateSecurityConfiguration(propertyFile);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public List<String> getUploadClassList() {
        return this.uploadClassList;
    }
}

