/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.util.InternalMessage;
import java.util.HashMap;
import java.util.Map;

public final class ValidatorUtil {
    private static final int RESULT_MAP_SIZE = 4;

    private ValidatorUtil() {
    }

    public static <T> void setErrorResult(ValidatorResult result, ErrorMessage error, String errorCode, T ... params) {
        result.setValidateResule(false);
        String message = InternalMessage.getMessage(error.getErrorMessage(), params);
        error.setErrorMessage(message);
        error.setErrorCode(errorCode);
        result.addErrorMessageParams(error);
    }

    public static <T> void setErrorResult(ValidatorResult result, String errorKey, String errorMessage, String errorCode, T ... params) {
        result.setValidateResule(false);
        String message = InternalMessage.getMessage(errorMessage, params);
        ErrorMessage error = new ErrorMessage(errorKey, message, errorCode);
        result.addErrorMessageParams(error);
    }

    public static Map<String, ValidatorResult> getValidateResultMap(ErrorMessage error, String errorCode) {
        HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(4);
        ValidatorResult result = new ValidatorResult();
        ValidatorUtil.setErrorResult(result, error, errorCode, new Object[0]);
        resultMap.put(error.getErrorKey(), result);
        return resultMap;
    }

    public static ValidatorResult getValidateResult(ErrorMessage error, String errorCode) {
        ValidatorResult result = new ValidatorResult();
        ValidatorUtil.setErrorResult(result, error, errorCode, new Object[0]);
        return result;
    }

    public static ValidatorResult getValidateResult(ErrorMessage error) {
        String internalMessage = InternalMessage.getMessage(error.getErrorMessage());
        error.setErrorMessage(internalMessage);
        return new ValidatorResult(false, error);
    }

    public static <T> ValidatorResult getResult(String key, String message, String code, boolean success, T ... params) {
        String internalMessage = InternalMessage.getMessage(message, params);
        ErrorMessage error = new ErrorMessage(key, internalMessage, code);
        return new ValidatorResult(success, error);
    }
}

